/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.test.junit.jupiter.params.provider;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.beta.base.KiwiStrings2;
import org.kiwiproject.beta.test.junit.jupiter.params.provider.RandomCapitalizationSource;

public class RandomCapitalizationArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<RandomCapitalizationSource> {
    private RandomCapitalizationSource randomCapitalizationSource;

    public void accept(RandomCapitalizationSource randomCapitalizationSource) {
        this.randomCapitalizationSource = randomCapitalizationSource;
    }

    public Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context) {
        String value = this.randomCapitalizationSource.value();
        int count = this.randomCapitalizationSource.count();
        KiwiPreconditions.checkArgumentNotBlank((String)value, (String)"value must not be blank");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count must be greater than zero");
        Set<String> variants = RandomCapitalizationArgumentsProvider.getCaseVariants(value, count, this.randomCapitalizationSource.type());
        return variants.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Set<String> getCaseVariants(String value, int count, RandomCapitalizationSource.Type type) {
        if (type == RandomCapitalizationSource.Type.RANDOM) {
            return KiwiStrings2.randomCaseVariants(value, count);
        }
        return KiwiStrings2.standardCaseVariants(value);
    }
}

