/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.dropwizard;

import com.google.common.annotations.Beta;
import io.dropwizard.lifecycle.Managed;
import lombok.Generated;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.logging.LazyLogParameterSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ManagedCamelContext
implements Managed {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ManagedCamelContext.class);
    private final String name;
    private final CamelContext camelContext;

    public ManagedCamelContext(CamelContext camelContext) {
        this("camel-context-" + System.currentTimeMillis(), camelContext);
    }

    public ManagedCamelContext(String name, CamelContext camelContext) {
        this.name = KiwiPreconditions.requireNotBlank((String)name);
        this.camelContext = (CamelContext)KiwiPreconditions.requireNotNull((Object)camelContext);
    }

    public void start() {
        LOG.info("Starting Camel context {}", (Object)this.name);
        this.camelContext.start();
        Object[] objectArray = new Object[3];
        objectArray[0] = this.name;
        objectArray[1] = LazyLogParameterSupplier.lazy(() -> ((CamelContext)this.camelContext).getRoutesSize());
        objectArray[2] = LazyLogParameterSupplier.lazy(() -> this.camelContext.getRoutes().stream().map(Route::getId).toList());
        LOG.info("Started Camel context {} has {} routes. Route IDs: {}", objectArray);
    }

    public void stop() {
        LOG.info("Stopping Camel context {}", (Object)this.name);
        this.camelContext.stop();
    }
}

