/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.jdbc;

import com.google.common.annotations.Beta;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.stream.IntStream;
import lombok.Generated;
import org.kiwiproject.jdbc.UncheckedSQLException;

@Beta
public final class KiwiJdbcMetaData {
    public static boolean resultSetContainsColumnLabel(ResultSet rs, String columnLabel) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            int foundColNum = IntStream.rangeClosed(1, columnCount).filter(colNum -> KiwiJdbcMetaData.metaDataColumnLabelEquals(metaData, colNum, columnLabel)).findFirst().orElse(0);
            return foundColNum > 0;
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e);
        }
    }

    private static boolean metaDataColumnLabelEquals(ResultSetMetaData metaData, int colNum, String columnLabel) {
        try {
            return metaData.getColumnLabel(colNum).equalsIgnoreCase(columnLabel);
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e);
        }
    }

    @Generated
    private KiwiJdbcMetaData() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

