/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.kiwiproject.base.KiwiCasts;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.beta.base.TypeMismatchException;
import org.kiwiproject.collect.KiwiCollections;
import org.kiwiproject.collect.KiwiMaps;

@Beta
public final class KiwiCasts2 {
    public static final int DEFAULT_MAX_NON_NULL_CHECKS = 10;
    public static final int DEFAULT_MAX_TYPE_CHECKS = 10;
    private static final CollectionCheckStrategy DEFAULT_COLLECTION_CHECK_STRATEGY = new DefaultCollectionCheckStrategy();
    private static final DefaultListCheckStrategy DEFAULT_LIST_CHECK_STRATEGY = new DefaultListCheckStrategy();
    private static final SetCheckStrategy DEFAULT_SET_CHECK_STRATEGY = new DefaultSetCheckStrategy();
    private static final MapCheckStrategy DEFAULT_MAP_CHECK_STRATEGY = new DefaultMapCheckStrategy();
    private static final String STRATEGY_MUST_NOT_BE_NULL = "strategy must not be null";

    public static <T> T uncheckedCast(Object object) {
        return (T)KiwiCasts.uncheckedCast((Object)object);
    }

    public static <T> Collection<T> castToCollectionAndCheckElements(Class<T> expectedType, Object object) {
        return KiwiCasts2.castToCollectionAndCheckElements(expectedType, object, DEFAULT_COLLECTION_CHECK_STRATEGY);
    }

    public static <T> Collection<T> castToCollectionAndCheckElements(Class<T> expectedType, Object object, CollectionCheckStrategy strategy) {
        KiwiCasts2.checkObjectNotNull(object);
        KiwiCasts2.checkExpectedTypeNotNull(expectedType);
        KiwiPreconditions.checkArgumentNotNull((Object)strategy, (String)STRATEGY_MUST_NOT_BE_NULL);
        try {
            Collection coll = (Collection)KiwiCasts2.uncheckedCast(object);
            return strategy.checkElements(expectedType, coll);
        }
        catch (ClassCastException e) {
            throw KiwiCasts2.typeMismatchExceptionForUnexpectedType(Collection.class, object, e);
        }
    }

    public static <T> List<T> castToListAndCheckElements(Class<T> expectedType, Object object) {
        return KiwiCasts2.castToListAndCheckElements(expectedType, object, DEFAULT_LIST_CHECK_STRATEGY);
    }

    public static <T> List<T> castToListAndCheckElements(Class<T> expectedType, Object object, ListCheckStrategy strategy) {
        KiwiCasts2.checkObjectNotNull(object);
        KiwiCasts2.checkExpectedTypeNotNull(expectedType);
        KiwiPreconditions.checkArgumentNotNull((Object)strategy, (String)STRATEGY_MUST_NOT_BE_NULL);
        try {
            List list = (List)KiwiCasts2.uncheckedCast(object);
            return strategy.checkElements(expectedType, list);
        }
        catch (ClassCastException e) {
            throw KiwiCasts2.typeMismatchExceptionForUnexpectedType(List.class, object, e);
        }
    }

    private static <T> ElementCheckResult checkElementsStandardStrategy(Class<?> expectedType, Collection<T> coll, int maxNonNullChecks, int maxElementTypeChecks) {
        if (KiwiCollections.isNullOrEmpty(coll)) {
            return ElementCheckResult.okCollection();
        }
        Iterator<T> iterator = coll.iterator();
        int nullCheckCount = 0;
        int typeCheckCount = 0;
        while (iterator.hasNext()) {
            T value = iterator.next();
            if (Objects.isNull(value)) {
                if (++nullCheckCount <= maxNonNullChecks) continue;
                return ElementCheckResult.okCollection();
            }
            if (KiwiCasts2.isNotExpectedType(expectedType, value)) {
                return ElementCheckResult.foundInvalidType(value);
            }
            if (++typeCheckCount < maxElementTypeChecks) continue;
            break;
        }
        return ElementCheckResult.okCollection();
    }

    private static TypeMismatchException newCollectionTypeMismatch(Class<?> collectionType, Class<?> expectedType, ElementCheckResult checkResult) {
        return TypeMismatchException.forUnexpectedCollectionElementType(collectionType, expectedType, checkResult.invalidValue().getClass());
    }

    public static <T> Set<T> castToSetAndCheckElements(Class<T> expectedType, Object object) {
        return KiwiCasts2.castToSetAndCheckElements(expectedType, object, DEFAULT_SET_CHECK_STRATEGY);
    }

    public static <T> Set<T> castToSetAndCheckElements(Class<T> expectedType, Object object, SetCheckStrategy strategy) {
        KiwiCasts2.checkObjectNotNull(object);
        KiwiCasts2.checkExpectedTypeNotNull(expectedType);
        KiwiPreconditions.checkArgumentNotNull((Object)strategy, (String)STRATEGY_MUST_NOT_BE_NULL);
        try {
            Set set = (Set)KiwiCasts2.uncheckedCast(object);
            return strategy.checkElements(expectedType, set);
        }
        catch (ClassCastException e) {
            throw KiwiCasts2.typeMismatchExceptionForUnexpectedType(Set.class, object, e);
        }
    }

    private static <T> void checkExpectedTypeNotNull(Class<T> expectedType) {
        KiwiPreconditions.checkArgumentNotNull(expectedType, (String)"expectedType must not be null");
    }

    private static boolean isNotExpectedType(Class<?> expectedType, Object object) {
        return !KiwiCasts2.isExpectedType(expectedType, object);
    }

    private static boolean isExpectedType(Class<?> expectedType, Object object) {
        return expectedType.isAssignableFrom(object.getClass());
    }

    public static <K, V> Map<K, V> castToMapAndCheckEntries(Class<K> keyType, Class<V> valueType, Object object) {
        return KiwiCasts2.castToMapAndCheckEntries(keyType, valueType, object, DEFAULT_MAP_CHECK_STRATEGY);
    }

    public static <K, V> Map<K, V> castToMapAndCheckEntries(Class<K> keyType, Class<V> valueType, Object object, MapCheckStrategy strategy) {
        KiwiCasts2.checkObjectNotNull(object);
        KiwiPreconditions.checkArgumentNotNull(keyType, (String)"keyType must not be null");
        KiwiPreconditions.checkArgumentNotNull(valueType, (String)"valueType must not be null");
        KiwiPreconditions.checkArgumentNotNull((Object)strategy, (String)STRATEGY_MUST_NOT_BE_NULL);
        try {
            Map map = (Map)KiwiCasts2.uncheckedCast(object);
            return strategy.checkEntries(keyType, valueType, map);
        }
        catch (ClassCastException e) {
            throw KiwiCasts2.typeMismatchExceptionForUnexpectedType(Map.class, object, e);
        }
    }

    private static void checkObjectNotNull(Object object) {
        KiwiPreconditions.checkArgumentNotNull((Object)object, (String)"object must not be null");
    }

    private static <T> TypeMismatchException typeMismatchExceptionForUnexpectedType(Class<T> expectedType, Object object, ClassCastException e) {
        return TypeMismatchException.forUnexpectedTypeWithCause(expectedType, object.getClass(), e);
    }

    @Generated
    private KiwiCasts2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface CollectionCheckStrategy {
        public <T> Collection<T> checkElements(Class<T> var1, Collection<T> var2) throws TypeMismatchException;
    }

    public static class DefaultListCheckStrategy
    implements ListCheckStrategy {
        private final StandardListCheckStrategy strategy = StandardListCheckStrategy.of(10, 1);

        @Override
        public <T> List<T> checkElements(Class<T> expectedType, List<T> list) {
            return this.strategy.checkElements(expectedType, list);
        }
    }

    public static interface ListCheckStrategy {
        public <T> List<T> checkElements(Class<T> var1, List<T> var2) throws TypeMismatchException;
    }

    private record ElementCheckResult(boolean ok, Object invalidValue) {
        static ElementCheckResult okCollection() {
            return new ElementCheckResult(true, null);
        }

        static ElementCheckResult foundInvalidType(Object value) {
            KiwiPreconditions.checkArgumentNotNull((Object)value, (String)"value must not be null");
            return new ElementCheckResult(false, value);
        }
    }

    public static interface SetCheckStrategy {
        public <T> Set<T> checkElements(Class<T> var1, Set<T> var2) throws TypeMismatchException;
    }

    public static interface MapCheckStrategy {
        public <K, V> Map<K, V> checkEntries(Class<K> var1, Class<V> var2, Map<K, V> var3) throws TypeMismatchException;
    }

    public static class DefaultCollectionCheckStrategy
    implements CollectionCheckStrategy {
        private final StandardCollectionCheckStrategy strategy = StandardCollectionCheckStrategy.of(10, 1);

        @Override
        public <T> Collection<T> checkElements(Class<T> expectedType, Collection<T> coll) {
            return this.strategy.checkElements(expectedType, coll);
        }
    }

    public static class DefaultSetCheckStrategy
    implements SetCheckStrategy {
        private final StandardSetCheckStrategy strategy = StandardSetCheckStrategy.of(10, 1);

        @Override
        public <T> Set<T> checkElements(Class<T> expectedType, Set<T> set) {
            return this.strategy.checkElements(expectedType, set);
        }
    }

    public static class DefaultMapCheckStrategy
    implements MapCheckStrategy {
        private final StandardMapCheckStrategy strategy = StandardMapCheckStrategy.of(10, 1);

        @Override
        public <K, V> Map<K, V> checkEntries(Class<K> keyType, Class<V> valueType, Map<K, V> map) {
            return this.strategy.checkEntries(keyType, valueType, map);
        }
    }

    public static class StandardMapCheckStrategy
    implements MapCheckStrategy {
        private final int maxNonNullChecks;
        private final int maxEntryTypeChecks;

        private StandardMapCheckStrategy(int maxNonNullChecks, int maxEntryTypeChecks) {
            this.maxNonNullChecks = KiwiPreconditions.requirePositiveOrZero((int)maxNonNullChecks);
            this.maxEntryTypeChecks = KiwiPreconditions.requirePositive((int)maxEntryTypeChecks);
        }

        public static StandardMapCheckStrategy ofDefaults() {
            return new StandardMapCheckStrategy(10, 10);
        }

        public static StandardMapCheckStrategy of(int maxNonNullChecks, int maxElementTypeChecks) {
            return new StandardMapCheckStrategy(maxNonNullChecks, maxElementTypeChecks);
        }

        @Override
        public <K, V> Map<K, V> checkEntries(Class<K> keyType, Class<V> valueType, Map<K, V> map) {
            EntryCheckResult checkResult = this.checkEntriesInternal(keyType, valueType, map);
            if (checkResult.ok()) {
                return map;
            }
            EntryType entryType = Objects.requireNonNull(checkResult.entryType(), "entryType must not be null when result is not ok");
            if (entryType == EntryType.KEY) {
                throw TypeMismatchException.forUnexpectedMapKeyType(keyType, checkResult.invalidValue().getClass());
            }
            StandardMapCheckStrategy.checkEntryTypeIsValue(checkResult);
            throw TypeMismatchException.forUnexpectedMapValueType(valueType, checkResult.invalidValue().getClass());
        }

        @VisibleForTesting
        static void checkEntryTypeIsValue(EntryCheckResult checkResult) {
            Preconditions.checkState((checkResult.entryType() == EntryType.VALUE ? 1 : 0) != 0, (String)"EntryCheckResult has unexpected entryType: %s", (Object)((Object)checkResult.entryType()));
        }

        private <K, V> EntryCheckResult checkEntriesInternal(Class<?> expectedKeyType, Class<?> expectedValueType, Map<K, V> map) {
            if (KiwiMaps.isNullOrEmpty(map)) {
                return EntryCheckResult.okMap();
            }
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            int nullCheckCount = 0;
            int typeCheckCount = 0;
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                K key = entry.getKey();
                V value = entry.getValue();
                boolean keyIsNotNull = Objects.nonNull(key);
                boolean valueIsNotNull = Objects.nonNull(value);
                if (StandardMapCheckStrategy.eitherIsNull(key, value) && ++nullCheckCount > this.maxNonNullChecks) {
                    return EntryCheckResult.okMap();
                }
                if (keyIsNotNull && KiwiCasts2.isNotExpectedType(expectedKeyType, key)) {
                    return EntryCheckResult.foundInvalidType(EntryType.KEY, key);
                }
                if (valueIsNotNull && KiwiCasts2.isNotExpectedType(expectedValueType, value)) {
                    return EntryCheckResult.foundInvalidType(EntryType.VALUE, value);
                }
                if (!keyIsNotNull && !valueIsNotNull || ++typeCheckCount < this.maxEntryTypeChecks) continue;
                break;
            }
            return EntryCheckResult.okMap();
        }

        private static boolean eitherIsNull(Object o1, Object o2) {
            return Objects.isNull(o1) || Objects.isNull(o2);
        }

        @VisibleForTesting
        record EntryCheckResult(boolean ok, EntryType entryType, Object invalidValue) {
            static EntryCheckResult okMap() {
                return new EntryCheckResult(true, null, null);
            }

            static EntryCheckResult foundInvalidType(EntryType entryType, Object value) {
                KiwiPreconditions.checkArgumentNotNull((Object)((Object)entryType), (String)"entryType must not be null");
                KiwiPreconditions.checkArgumentNotNull((Object)value, (String)"value must not be null");
                return new EntryCheckResult(false, entryType, value);
            }
        }

        static enum EntryType {
            KEY,
            VALUE;

        }
    }

    public static class StandardSetCheckStrategy
    implements SetCheckStrategy {
        private final int maxNonNullChecks;
        private final int maxElementTypeChecks;

        private StandardSetCheckStrategy(int maxNonNullChecks, int maxElementTypeChecks) {
            this.maxNonNullChecks = KiwiPreconditions.requirePositiveOrZero((int)maxNonNullChecks);
            this.maxElementTypeChecks = KiwiPreconditions.requirePositive((int)maxElementTypeChecks);
        }

        public static StandardSetCheckStrategy ofDefaults() {
            return new StandardSetCheckStrategy(10, 10);
        }

        public static StandardSetCheckStrategy of(int maxNonNullChecks, int maxElementTypeChecks) {
            return new StandardSetCheckStrategy(maxNonNullChecks, maxElementTypeChecks);
        }

        @Override
        public <T> Set<T> checkElements(Class<T> expectedType, Set<T> set) throws TypeMismatchException {
            ElementCheckResult checkResult = KiwiCasts2.checkElementsStandardStrategy(expectedType, set, this.maxNonNullChecks, this.maxElementTypeChecks);
            if (checkResult.ok()) {
                return set;
            }
            throw KiwiCasts2.newCollectionTypeMismatch(Set.class, expectedType, checkResult);
        }
    }

    public static class StandardListCheckStrategy
    implements ListCheckStrategy {
        private final int maxNonNullChecks;
        private final int maxElementTypeChecks;

        private StandardListCheckStrategy(int maxNonNullChecks, int maxElementTypeChecks) {
            this.maxNonNullChecks = KiwiPreconditions.requirePositiveOrZero((int)maxNonNullChecks);
            this.maxElementTypeChecks = KiwiPreconditions.requirePositive((int)maxElementTypeChecks);
        }

        public static StandardListCheckStrategy ofDefaults() {
            return new StandardListCheckStrategy(10, 10);
        }

        public static StandardListCheckStrategy of(int maxNonNullChecks, int maxElementTypeChecks) {
            return new StandardListCheckStrategy(maxNonNullChecks, maxElementTypeChecks);
        }

        @Override
        public <T> List<T> checkElements(Class<T> expectedType, List<T> list) throws TypeMismatchException {
            ElementCheckResult checkResult = KiwiCasts2.checkElementsStandardStrategy(expectedType, list, this.maxNonNullChecks, this.maxElementTypeChecks);
            if (checkResult.ok()) {
                return list;
            }
            throw KiwiCasts2.newCollectionTypeMismatch(List.class, expectedType, checkResult);
        }
    }

    public static class StandardCollectionCheckStrategy
    implements CollectionCheckStrategy {
        private final int maxNonNullChecks;
        private final int maxElementTypeChecks;

        private StandardCollectionCheckStrategy(int maxNonNullChecks, int maxElementTypeChecks) {
            this.maxNonNullChecks = KiwiPreconditions.requirePositiveOrZero((int)maxNonNullChecks);
            this.maxElementTypeChecks = KiwiPreconditions.requirePositive((int)maxElementTypeChecks);
        }

        public static StandardCollectionCheckStrategy ofDefaults() {
            return new StandardCollectionCheckStrategy(10, 10);
        }

        public static StandardCollectionCheckStrategy of(int maxNonNullChecks, int maxElementTypeChecks) {
            return new StandardCollectionCheckStrategy(maxNonNullChecks, maxElementTypeChecks);
        }

        @Override
        public <T> Collection<T> checkElements(Class<T> expectedType, Collection<T> coll) throws TypeMismatchException {
            ElementCheckResult checkResult = KiwiCasts2.checkElementsStandardStrategy(expectedType, coll, this.maxNonNullChecks, this.maxElementTypeChecks);
            if (checkResult.ok()) {
                return coll;
            }
            throw KiwiCasts2.newCollectionTypeMismatch(Collection.class, expectedType, checkResult);
        }
    }
}

