/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.jar;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.beta.base.jar.AttributeLookupStatus;

public record AttributeLookupResult(AttributeLookupStatus lookupStatus, @Nullable String value, @Nullable Exception error) {
    public AttributeLookupResult(AttributeLookupStatus lookupStatus, @Nullable String value, @Nullable Exception error) {
        if (lookupStatus == AttributeLookupStatus.EXISTS) {
            KiwiPreconditions.checkArgumentNotNull((Object)value, (String)"value must not be null when lookup succeeds");
            KiwiPreconditions.checkArgumentIsNull((Object)error, (String)"error must be null when lookup succeeds");
        } else {
            KiwiPreconditions.checkArgumentIsNull((Object)value, (String)"value must be null when lookup fails");
        }
    }

    public boolean failed() {
        return !this.succeeded();
    }

    public boolean succeeded() {
        return this.lookupStatus == AttributeLookupStatus.EXISTS;
    }

    public boolean containsValue() {
        return Objects.nonNull(this.value);
    }

    public Optional<String> maybeValue() {
        return Optional.ofNullable(this.value);
    }

    public String valueOrThrow() {
        Preconditions.checkState((boolean)Objects.nonNull(this.value), (Object)"expected value not to be null");
        return this.value;
    }
}

