/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.jar;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.beta.base.jar.ManifestLookupResult;
import org.kiwiproject.beta.base.jar.ManifestLookupStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class JarManifests {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(JarManifests.class);

    public static String getMainAttributeValueOrThrow(Class<?> theClass, String name) {
        return JarManifests.getMainAttributeValue(theClass, name).orElseThrow(() -> new IllegalStateException(KiwiStrings.f((String)"Unable to get value for main attribute {} for {}", (Object[])new Object[]{name, theClass})));
    }

    public static Optional<String> getMainAttributeValue(Class<?> theClass, String name) {
        return JarManifests.getManifest(theClass).map(manifest -> JarManifests.getMainAttributeValue(manifest, name)).flatMap(Function.identity());
    }

    public static Optional<String> getMainAttributeValue(Manifest manifest, String name) {
        String value = manifest.getMainAttributes().getValue(name);
        return Optional.ofNullable(value);
    }

    public static Map<String, String> getMainAttributesAsMapOrThrow(Class<?> theClass) {
        Manifest manifest = JarManifests.getManifestOrThrow(theClass);
        return JarManifests.getMainAttributesAsMap(manifest);
    }

    public static Map<String, String> getMainAttributesAsMap(Manifest manifest) {
        return manifest.getMainAttributes().entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
    }

    public static Manifest getManifestOrThrow(Class<?> theClass) {
        ClassHolder classHolder = new ClassHolder(theClass);
        ManifestLookupResult lookupResult = JarManifests.getManifest(classHolder);
        switch (lookupResult.lookupStatus()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SUCCESS: {
                break;
            }
            case FAILURE: {
                throw JarManifests.illegalStateExceptionFor(lookupResult, theClass);
            }
        }
        return lookupResult.manifestOrThrow();
    }

    private static IllegalStateException illegalStateExceptionFor(ManifestLookupResult lookupResult, Class<?> theClass) {
        String errorMessage = "Unable to get manifest for " + String.valueOf(theClass);
        return Optional.ofNullable(lookupResult.error()).map(error -> new IllegalStateException(errorMessage, (Throwable)error)).orElseGet(() -> new IllegalStateException(errorMessage));
    }

    public static Optional<Manifest> getManifest(Class<?> theClass) {
        ClassHolder classHolder = new ClassHolder(theClass);
        ManifestLookupResult lookupResult = JarManifests.getManifest(classHolder);
        return lookupResult.maybeManifest();
    }

    static ManifestLookupResult getManifest(ClassHolder holder) {
        Class<?> theClass = holder.getContainedClass();
        try {
            String errorMessage;
            CodeSource codeSource = holder.getProtectionDomain().getCodeSource();
            if (Objects.nonNull(codeSource)) {
                URL location = codeSource.getLocation();
                LOG.trace("CodeSource location of {}: {}", theClass, (Object)location);
                if (Objects.nonNull(location)) {
                    return JarManifests.getManifestWithResult(location.toURI());
                }
                errorMessage = KiwiStrings.f((String)"The Location of the CodeSource was null. CodeSource: {}", (Object[])new Object[]{codeSource});
            } else {
                errorMessage = "The CodeSource from the ProtectionDomain was null";
            }
            LOG.debug("Unable to get manifest of JAR file for {}, cause: {}", theClass, (Object)errorMessage);
            return new ManifestLookupResult(ManifestLookupStatus.FAILURE, null, null, errorMessage);
        }
        catch (Exception e) {
            LOG.debug("Error getting manifest of JAR for {}", theClass, (Object)e);
            return new ManifestLookupResult(ManifestLookupStatus.FAILURE, null, e, null);
        }
    }

    public static Optional<Manifest> getManifest(URI jarFileURI) {
        ManifestLookupResult lookupResult = JarManifests.getManifestWithResult(jarFileURI);
        return lookupResult.maybeManifest();
    }

    static ManifestLookupResult getManifestWithResult(URI jarFileURI) {
        ManifestLookupResult manifestLookupResult;
        JarFile jarFile = new JarFile(new File(jarFileURI));
        try {
            Manifest manifest = jarFile.getManifest();
            manifestLookupResult = new ManifestLookupResult(ManifestLookupStatus.SUCCESS, manifest, null, null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.debug("Error getting manifest of JAR for URI {}", (Object)jarFileURI, (Object)e);
                return new ManifestLookupResult(ManifestLookupStatus.FAILURE, null, e, null);
            }
        }
        jarFile.close();
        return manifestLookupResult;
    }

    @Generated
    private JarManifests() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @VisibleForTesting
    static class ClassHolder {
        private final Class<?> theClass;

        Class<?> getContainedClass() {
            return this.theClass;
        }

        ProtectionDomain getProtectionDomain() {
            return this.theClass.getProtectionDomain();
        }

        @ConstructorProperties(value={"theClass"})
        @Generated
        public ClassHolder(Class<?> theClass) {
            this.theClass = theClass;
        }
    }
}

