/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.jar;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.beta.base.jar.ManifestLookupStatus;

public record ManifestLookupResult(ManifestLookupStatus lookupStatus, @Nullable Manifest manifest, @Nullable Exception error, @Nullable String errorMessage) {
    public ManifestLookupResult(ManifestLookupStatus lookupStatus, @Nullable Manifest manifest, @Nullable Exception error, @Nullable String errorMessage) {
        if (lookupStatus == ManifestLookupStatus.SUCCESS) {
            KiwiPreconditions.checkArgumentNotNull((Object)manifest, (String)"manifest must not be null when lookup succeeds");
            KiwiPreconditions.checkArgumentIsNull((Object)error, (String)"error must be null when lookup succeeds");
            KiwiPreconditions.checkArgumentIsNull((Object)errorMessage, (String)"error must be null when lookup succeeds");
        } else {
            KiwiPreconditions.checkArgumentIsNull((Object)manifest, (String)"manifest must be null when lookup fails");
        }
    }

    public boolean failed() {
        return !this.succeeded();
    }

    public boolean succeeded() {
        return this.lookupStatus == ManifestLookupStatus.SUCCESS;
    }

    public Optional<Manifest> maybeManifest() {
        return Optional.ofNullable(this.manifest);
    }

    public Manifest manifestOrThrow() {
        Preconditions.checkState((boolean)Objects.nonNull(this.manifest), (Object)"expected manifest not to be null");
        return this.manifest;
    }
}

