/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.process;

import com.google.common.annotations.Beta;
import io.dropwizard.util.DataSize;
import io.dropwizard.util.Duration;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

@Beta
public class ProcessOutputHandlerConfig {
    public static final int DEFAULT_THREAD_POOL_SIZE = 5;
    public static final int DEFAULT_BUFFER_SIZE_BYTES = 2048;
    public static final long DEFAULT_SLEEP_DURATION_MILLIS = 1000L;
    @NotNull
    private Integer threadPoolSize = 5;
    @NotNull
    private DataSize bufferCapacity = DataSize.bytes((long)2048L);
    @NotNull
    private Duration sleepTime = Duration.milliseconds((long)1000L);

    public int bufferCapacityInBytes() {
        return Math.toIntExact(this.bufferCapacity.toBytes());
    }

    public long sleepTimeInMillis() {
        return this.sleepTime.toMilliseconds();
    }

    @Generated
    public Integer getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Generated
    public DataSize getBufferCapacity() {
        return this.bufferCapacity;
    }

    @Generated
    public Duration getSleepTime() {
        return this.sleepTime;
    }

    @Generated
    public void setThreadPoolSize(Integer threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    @Generated
    public void setBufferCapacity(DataSize bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    @Generated
    public void setSleepTime(Duration sleepTime) {
        this.sleepTime = sleepTime;
    }

    @Generated
    public String toString() {
        return "ProcessOutputHandlerConfig(threadPoolSize=" + this.getThreadPoolSize() + ", bufferCapacity=" + String.valueOf(this.getBufferCapacity()) + ", sleepTime=" + String.valueOf(this.getSleepTime()) + ")";
    }
}

