/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.base.process;

import com.google.common.annotations.Beta;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.kiwiproject.base.process.Processes;

@Beta
public class ProcessResult {
    @NonNull
    private final List<String> stdOutLines;
    @NonNull
    private final List<String> stdErrLines;
    private final Integer exitCode;
    private final boolean timedOut;
    private final int timeoutThresholdMillis;
    private final Throwable error;

    public static boolean isSuccessfulExitCode(int exitCode) {
        return Processes.isSuccessfulExitCode((int)exitCode);
    }

    public Optional<Integer> getExitCode() {
        return Optional.ofNullable(this.exitCode);
    }

    public boolean isSuccessfulExit() {
        return ProcessResult.isSuccessfulExitCode(this.getExitCode().orElse(1));
    }

    public boolean isNotSuccessfulExit() {
        return !this.isSuccessfulExit();
    }

    public boolean hasError() {
        return Objects.nonNull(this.error);
    }

    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error);
    }

    @ConstructorProperties(value={"stdOutLines", "stdErrLines", "exitCode", "timedOut", "timeoutThresholdMillis", "error"})
    @Generated
    ProcessResult(@NonNull List<String> stdOutLines, @NonNull List<String> stdErrLines, Integer exitCode, boolean timedOut, int timeoutThresholdMillis, Throwable error) {
        if (stdOutLines == null) {
            throw new NullPointerException("stdOutLines is marked non-null but is null");
        }
        if (stdErrLines == null) {
            throw new NullPointerException("stdErrLines is marked non-null but is null");
        }
        this.stdOutLines = stdOutLines;
        this.stdErrLines = stdErrLines;
        this.exitCode = exitCode;
        this.timedOut = timedOut;
        this.timeoutThresholdMillis = timeoutThresholdMillis;
        this.error = error;
    }

    @Generated
    public static ProcessResultBuilder builder() {
        return new ProcessResultBuilder();
    }

    @NonNull
    @Generated
    public List<String> getStdOutLines() {
        return this.stdOutLines;
    }

    @NonNull
    @Generated
    public List<String> getStdErrLines() {
        return this.stdErrLines;
    }

    @Generated
    public boolean isTimedOut() {
        return this.timedOut;
    }

    @Generated
    public int getTimeoutThresholdMillis() {
        return this.timeoutThresholdMillis;
    }

    @Generated
    public static class ProcessResultBuilder {
        @Generated
        private List<String> stdOutLines;
        @Generated
        private List<String> stdErrLines;
        @Generated
        private Integer exitCode;
        @Generated
        private boolean timedOut;
        @Generated
        private int timeoutThresholdMillis;
        @Generated
        private Throwable error;

        @Generated
        ProcessResultBuilder() {
        }

        @Generated
        public ProcessResultBuilder stdOutLines(@NonNull List<String> stdOutLines) {
            if (stdOutLines == null) {
                throw new NullPointerException("stdOutLines is marked non-null but is null");
            }
            this.stdOutLines = stdOutLines;
            return this;
        }

        @Generated
        public ProcessResultBuilder stdErrLines(@NonNull List<String> stdErrLines) {
            if (stdErrLines == null) {
                throw new NullPointerException("stdErrLines is marked non-null but is null");
            }
            this.stdErrLines = stdErrLines;
            return this;
        }

        @Generated
        public ProcessResultBuilder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        @Generated
        public ProcessResultBuilder timedOut(boolean timedOut) {
            this.timedOut = timedOut;
            return this;
        }

        @Generated
        public ProcessResultBuilder timeoutThresholdMillis(int timeoutThresholdMillis) {
            this.timeoutThresholdMillis = timeoutThresholdMillis;
            return this;
        }

        @Generated
        public ProcessResultBuilder error(Throwable error) {
            this.error = error;
            return this;
        }

        @Generated
        public ProcessResult build() {
            return new ProcessResult(this.stdOutLines, this.stdErrLines, this.exitCode, this.timedOut, this.timeoutThresholdMillis, this.error);
        }

        @Generated
        public String toString() {
            return "ProcessResult.ProcessResultBuilder(stdOutLines=" + String.valueOf(this.stdOutLines) + ", stdErrLines=" + String.valueOf(this.stdErrLines) + ", exitCode=" + this.exitCode + ", timedOut=" + this.timedOut + ", timeoutThresholdMillis=" + this.timeoutThresholdMillis + ", error=" + String.valueOf(this.error) + ")";
        }
    }
}

