/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;

@Beta
public final class KiwiArrays2 {
    public static <T> T[] emptyArray(Class<T> type) {
        return KiwiArrays2.newArray(type, 0);
    }

    public static <T> T[] newArray(Class<T> type, int length) {
        KiwiPreconditions.checkArgumentNotNull(type);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"value must be positive or zero");
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> @Nullable T[] primitiveToObjectArrayOrNull(@Nullable Object primitiveArray, Class<T> wrapperType) {
        if (Objects.isNull(primitiveArray)) {
            return null;
        }
        return KiwiArrays2.primitiveToObjectArray(primitiveArray, wrapperType);
    }

    public static <T> Optional<T[]> primitiveToObjectArrayOrEmpty(@Nullable Object primitiveArray, Class<T> wrapperType) {
        if (Objects.isNull(primitiveArray)) {
            return Optional.empty();
        }
        return Optional.of(KiwiArrays2.primitiveToObjectArray(primitiveArray, wrapperType));
    }

    public static <T> T[] primitiveToObjectArray(Object primitiveArray, Class<T> wrapperType) {
        KiwiPreconditions.checkArgumentNotNull((Object)primitiveArray, (String)"primitiveArray must be not be null");
        KiwiPreconditions.checkArgumentNotNull(wrapperType, (String)"wrapperType must not be null");
        Preconditions.checkArgument((boolean)ClassUtils.isPrimitiveWrapper(wrapperType), (Object)"wrapperType must be a primitive wrapper type");
        Class<?> arrayClass = primitiveArray.getClass();
        Class<?> componentType = arrayClass.getComponentType();
        Preconditions.checkArgument((arrayClass.isArray() && componentType.isPrimitive() ? 1 : 0) != 0, (Object)"primitiveArray must be an array of a primitive type");
        if (componentType.equals(Boolean.TYPE)) {
            boolean[] primitiveBooleanArray = (boolean[])primitiveArray;
            return ArrayUtils.toObject((boolean[])primitiveBooleanArray);
        }
        if (componentType.equals(Byte.TYPE)) {
            byte[] primitiveByteArray = (byte[])primitiveArray;
            return ArrayUtils.toObject((byte[])primitiveByteArray);
        }
        if (componentType.equals(Character.TYPE)) {
            char[] primitiveCharArray = (char[])primitiveArray;
            return ArrayUtils.toObject((char[])primitiveCharArray);
        }
        if (componentType.equals(Double.TYPE)) {
            double[] primitiveDoubleArray = (double[])primitiveArray;
            return ArrayUtils.toObject((double[])primitiveDoubleArray);
        }
        if (componentType.equals(Float.TYPE)) {
            float[] primitiveFloatArray = (float[])primitiveArray;
            return ArrayUtils.toObject((float[])primitiveFloatArray);
        }
        if (componentType.equals(Integer.TYPE)) {
            int[] primitiveIntArray = (int[])primitiveArray;
            return ArrayUtils.toObject((int[])primitiveIntArray);
        }
        if (componentType.equals(Long.TYPE)) {
            long[] primitiveLongArray = (long[])primitiveArray;
            return ArrayUtils.toObject((long[])primitiveLongArray);
        }
        Preconditions.checkState((boolean)(primitiveArray instanceof short[]), (String)"expected array to be short[] since it is not any other primitive type, but was: %s", componentType);
        short[] primitiveShortArray = (short[])primitiveArray;
        return ArrayUtils.toObject((short[])primitiveShortArray);
    }

    @Generated
    private KiwiArrays2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

