/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.dao;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.beta.dao.AllowedFields;
import org.kiwiproject.collect.KiwiArrays;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.spring.data.KiwiSort;
import org.kiwiproject.spring.data.PagingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;

@Beta
public final class DaoHelpers {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DaoHelpers.class);

    public static void addSorts(StringBuilder query, AllowedFields allowedSortFields, PagingRequest pagingRequest) {
        DaoHelpers.checkQueryNotNull(query);
        DaoHelpers.checkAllowedSortFieldsNotNull(allowedSortFields);
        KiwiPreconditions.checkArgumentNotNull((Object)pagingRequest, (String)"pagingRequest must not be null");
        KiwiSort.Direction primarySortDirection = DaoHelpers.toKiwiSortDirectionOrNull(pagingRequest.getPrimaryDirection());
        KiwiSort.Direction secondarySortDirection = DaoHelpers.toKiwiSortDirectionOrNull(pagingRequest.getSecondaryDirection());
        DaoHelpers.addSorts(query, allowedSortFields, pagingRequest.getPrimarySort(), primarySortDirection, pagingRequest.getSecondarySort(), secondarySortDirection);
    }

    private static KiwiSort.Direction toKiwiSortDirectionOrNull(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Sort.Direction sortDirection) {
        return Objects.isNull(sortDirection) ? null : DaoHelpers.toKiwiSortDirection(sortDirection);
    }

    private static KiwiSort.Direction toKiwiSortDirection(Sort.Direction sortDirection) {
        KiwiPreconditions.checkArgumentNotNull((Object)sortDirection);
        return sortDirection.isAscending() ? KiwiSort.Direction.ASC : KiwiSort.Direction.DESC;
    }

    public static void addSort(StringBuilder query, AllowedFields allowedSortFields, KiwiSort sort) {
        DaoHelpers.checkQueryNotNull(query);
        DaoHelpers.checkAllowedSortFieldsNotNull(allowedSortFields);
        KiwiPreconditions.checkArgumentNotNull((Object)sort, (String)"sort must not be null");
        KiwiSort.Direction primarySortDirection = DaoHelpers.toKiwiSortDirection(sort);
        DaoHelpers.addSort(query, allowedSortFields, sort.getProperty(), primarySortDirection);
    }

    public static void addSort(StringBuilder query, AllowedFields allowedSortFields, String sortField, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable KiwiSort.Direction sortDirection) {
        DaoHelpers.addSorts(query, allowedSortFields, sortField, sortDirection, null, null);
    }

    public static void addSorts(StringBuilder query, AllowedFields allowedSortFields, KiwiSort primarySort, KiwiSort secondarySort) {
        KiwiPreconditions.checkArgumentNotNull((Object)primarySort, (String)"primarySort must not be null");
        KiwiPreconditions.checkArgumentNotNull((Object)secondarySort, (String)"secondarySort must not be null");
        KiwiSort.Direction primarySortDirection = DaoHelpers.toKiwiSortDirection(primarySort);
        KiwiSort.Direction secondarySortDirection = DaoHelpers.toKiwiSortDirection(secondarySort);
        DaoHelpers.addSorts(query, allowedSortFields, primarySort.getProperty(), primarySortDirection, secondarySort.getProperty(), secondarySortDirection);
    }

    public static void addSorts(StringBuilder query, AllowedFields allowedSortFields, @Nullable String primarySortField, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable KiwiSort.Direction primarySortDirection, @Nullable String secondarySortField, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable KiwiSort.Direction secondarySortDirection) {
        DaoHelpers.checkQueryNotNull(query);
        DaoHelpers.checkAllowedSortFieldsNotNull(allowedSortFields);
        DaoHelpers.logWarningIfOnlySecondarySort(primarySortField, secondarySortField, secondarySortDirection);
        if (StringUtils.isNotBlank((CharSequence)primarySortField)) {
            allowedSortFields.assertAllowed(primarySortField);
        }
        if (StringUtils.isNotBlank((CharSequence)secondarySortField)) {
            allowedSortFields.assertAllowed(secondarySortField);
        }
        if (StringUtils.isNotBlank((CharSequence)primarySortField)) {
            DaoHelpers.addSort(query, allowedSortFields, Connector.ORDER_BY, primarySortField, primarySortDirection);
            if (StringUtils.isNotBlank((CharSequence)secondarySortField)) {
                DaoHelpers.addSort(query, allowedSortFields, Connector.SORT_FIELD_SEPARATOR, secondarySortField, secondarySortDirection);
            }
        }
    }

    private static void logWarningIfOnlySecondarySort(String primarySortField, String secondarySortField, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable KiwiSort.Direction secondarySortDirection) {
        if (DaoHelpers.onlyContainsSecondarySort(primarySortField, secondarySortField)) {
            LOG.warn("A secondary sort ({} {}) was specified without a primary sort. Ignoring.", (Object)secondarySortField, (Object)secondarySortDirection);
        }
    }

    private static boolean onlyContainsSecondarySort(@Nullable String primarySortField, @Nullable String secondarySortField) {
        return StringUtils.isBlank((CharSequence)primarySortField) && StringUtils.isNotBlank((CharSequence)secondarySortField);
    }

    public static void addSorts(StringBuilder query, AllowedFields allowedSortFields, KiwiSort ... sorts) {
        DaoHelpers.checkQueryNotNull(query);
        DaoHelpers.checkAllowedSortFieldsNotNull(allowedSortFields);
        KiwiPreconditions.checkArgumentNotNull((Object)sorts, (String)"sorts (varargs) must not be null");
        if (KiwiArrays.isNullOrEmpty((Object[])sorts)) {
            return;
        }
        DaoHelpers.addSorts(query, allowedSortFields, Arrays.asList(sorts));
    }

    public static void addSorts(StringBuilder query, AllowedFields allowedSortFields, List<KiwiSort> sorts) {
        DaoHelpers.checkQueryNotNull(query);
        DaoHelpers.checkAllowedSortFieldsNotNull(allowedSortFields);
        KiwiPreconditions.checkArgumentNotNull(sorts, (String)"sorts must not be null");
        if (KiwiLists.isNullOrEmpty(sorts)) {
            return;
        }
        List<KiwiSort> nonNullSorts = sorts.stream().filter(Objects::nonNull).toList();
        nonNullSorts.forEach(sort -> allowedSortFields.assertAllowed(sort.getProperty()));
        KiwiSort firstSort = (KiwiSort)KiwiLists.first(nonNullSorts);
        DaoHelpers.addSort(query, allowedSortFields, Connector.ORDER_BY, firstSort.getProperty(), DaoHelpers.toKiwiSortDirection(firstSort));
        List remainingSorts = KiwiLists.subListExcludingFirst(nonNullSorts);
        remainingSorts.forEach(sort -> DaoHelpers.addSort(query, allowedSortFields, Connector.SORT_FIELD_SEPARATOR, sort.getProperty(), DaoHelpers.toKiwiSortDirection(sort)));
    }

    private static KiwiSort.Direction toKiwiSortDirection(KiwiSort sort) {
        KiwiPreconditions.checkArgumentNotNull((Object)sort);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)sort.getDirection()), (Object)"KiwiSort has a blank direction");
        return KiwiSort.Direction.valueOf((String)sort.getDirection().toUpperCase(Locale.US));
    }

    private static void addSort(StringBuilder query, AllowedFields allowedSortFields, Connector connector, String sortField, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable KiwiSort.Direction sortDirection) {
        DaoHelpers.checkQueryNotNull(query);
        DaoHelpers.checkAllowedSortFieldsNotNull(allowedSortFields);
        KiwiPreconditions.checkArgumentNotNull((Object)((Object)connector), (String)"connector must not be blank");
        KiwiPreconditions.checkArgumentNotBlank((String)sortField, (String)"sortField must not be blank");
        allowedSortFields.assertAllowed(sortField);
        query.append(connector.value).append(allowedSortFields.getPrefixedFieldName(sortField)).append(Connector.SORT_DIRECTION_SEPARATOR.value).append(Optional.ofNullable(sortDirection).orElse(KiwiSort.Direction.ASC));
    }

    private static void checkQueryNotNull(StringBuilder query) {
        KiwiPreconditions.checkArgumentNotNull((Object)query, (String)"query must not be null");
    }

    private static void checkAllowedSortFieldsNotNull(AllowedFields allowedSortFields) {
        KiwiPreconditions.checkArgumentNotNull((Object)allowedSortFields, (String)"allowedSortFields must not be null");
    }

    @Generated
    private DaoHelpers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static enum Connector {
        ORDER_BY(" order by "),
        SORT_FIELD_SEPARATOR(", "),
        SORT_DIRECTION_SEPARATOR(" ");

        final String value;

        private Connector(String value) {
            this.value = value;
        }
    }
}

