/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.jdbc;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.kiwiproject.beta.collect.KiwiArrays2;

@Beta
public final class KiwiJdbc2 {
    public static <T> List<T> arrayAsList(ResultSet rs, String columnLabel, Class<T> type) throws SQLException {
        Object[] ts = KiwiJdbc2.array(rs, columnLabel, type);
        return Lists.newArrayList((Object[])ts);
    }

    public static <T> Set<T> arrayAsSet(ResultSet rs, String columnLabel, Class<T> type) throws SQLException {
        Object[] ts = KiwiJdbc2.array(rs, columnLabel, type);
        return Sets.newHashSet((Object[])ts);
    }

    public static double[] doubleArray(ResultSet rs, String columnLabel) throws SQLException {
        Array javaSqlArray = rs.getArray(columnLabel);
        if (Objects.isNull(javaSqlArray)) {
            return new double[0];
        }
        Object array = javaSqlArray.getArray();
        Class<?> clazz = array.getClass();
        KiwiJdbc2.checkIsArray(clazz, columnLabel);
        Class<?> componentType = clazz.getComponentType();
        KiwiJdbc2.checkArrayType(componentType, columnLabel, Double.TYPE, Double.class);
        if (componentType.equals(Double.TYPE)) {
            return (double[])array;
        }
        Double[] doubleObjArray = (Double[])array;
        return Arrays.stream(doubleObjArray).mapToDouble(Double::doubleValue).toArray();
    }

    public static int[] intArray(ResultSet rs, String columnLabel) throws SQLException {
        Array javaSqlArray = rs.getArray(columnLabel);
        if (Objects.isNull(javaSqlArray)) {
            return new int[0];
        }
        Object array = javaSqlArray.getArray();
        Class<?> clazz = array.getClass();
        KiwiJdbc2.checkIsArray(clazz, columnLabel);
        Class<?> componentType = clazz.getComponentType();
        KiwiJdbc2.checkArrayType(componentType, columnLabel, Integer.TYPE, Integer.class);
        if (componentType.equals(Integer.TYPE)) {
            return (int[])array;
        }
        Integer[] intObjArray = (Integer[])array;
        return Arrays.stream(intObjArray).mapToInt(Integer::intValue).toArray();
    }

    public static long[] longArray(ResultSet rs, String columnLabel) throws SQLException {
        Array javaSqlArray = rs.getArray(columnLabel);
        if (Objects.isNull(javaSqlArray)) {
            return new long[0];
        }
        Object array = javaSqlArray.getArray();
        Class<?> clazz = array.getClass();
        KiwiJdbc2.checkIsArray(clazz, columnLabel);
        Class<?> componentType = clazz.getComponentType();
        KiwiJdbc2.checkArrayType(componentType, columnLabel, Long.TYPE, Long.class);
        if (componentType.equals(Long.TYPE)) {
            return (long[])array;
        }
        Long[] longObjArray = (Long[])array;
        return Arrays.stream(longObjArray).mapToLong(Long::longValue).toArray();
    }

    private static <T> void checkArrayType(Class<?> componentType, String columnLabel, Class<T> primitiveType, Class<T> wrapperType) {
        Preconditions.checkState((componentType.equals(primitiveType) || componentType.equals(wrapperType) ? 1 : 0) != 0, (String)"expected array of %s or %s in column '%s' but found array of: %s", (Object)primitiveType.getName(), (Object)wrapperType.getName(), (Object)columnLabel, componentType);
    }

    public static <T> T[] array(ResultSet rs, String columnLabel, Class<T> type) throws SQLException {
        Preconditions.checkArgument((!type.isPrimitive() ? 1 : 0) != 0, (Object)"primitive types are not supported; use a wrapper type or a dedicated primitive method");
        Array javaSqlArray = rs.getArray(columnLabel);
        if (Objects.isNull(javaSqlArray)) {
            return KiwiArrays2.emptyArray(type);
        }
        Object array = javaSqlArray.getArray();
        Class<?> clazz = array.getClass();
        KiwiJdbc2.checkIsArray(clazz, columnLabel);
        if (clazz.getComponentType().isPrimitive()) {
            return KiwiArrays2.primitiveToObjectArray(array, type);
        }
        return (Object[])array;
    }

    private static void checkIsArray(Class<?> clazz, String columnLabel) {
        Preconditions.checkState((boolean)clazz.isArray(), (String)"expected an array in column '%s' but found: %s", (Object)columnLabel, clazz);
    }

    @Generated
    private KiwiJdbc2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

