/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.net;

import com.google.common.annotations.Beta;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.net.KiwiUrls;

@Beta
public final class KiwiUrls2 {
    public static Set<URL> uniqueHostOnlyUrls(Collection<URL> urls) {
        return KiwiUrls2.uniqueAuthorityOnlyUrls(urls);
    }

    public static Set<URL> uniqueAuthorityOnlyUrls(Collection<URL> urls) {
        KiwiPreconditions.checkArgumentNotNull(urls, (String)"urls must not be null");
        return urls.stream().map(KiwiUrls2::hostOnlyUrlFrom).collect(Collectors.toUnmodifiableSet());
    }

    public static List<URL> uniqueAuthorityOnlyUrlsAsList(Collection<URL> urls) {
        KiwiPreconditions.checkArgumentNotNull(urls, (String)"urls must not be null");
        return urls.stream().map(KiwiUrls2::hostOnlyUrlFrom).map(URL::toString).distinct().map(KiwiUrls::createUrlObject).toList();
    }

    public static URL hostOnlyUrlFrom(URL url) {
        return KiwiUrls2.authorityOnlyUrlFrom(url);
    }

    public static URL authorityOnlyUrlFrom(URL url) {
        KiwiPreconditions.checkArgumentNotNull((Object)url, (String)"url must not be null");
        String urlSpec = url.getProtocol() + "://" + url.getAuthority();
        return KiwiUrls.createUrlObject((String)urlSpec);
    }

    @Generated
    private KiwiUrls2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

