/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.slf4j;

import com.google.common.annotations.Beta;
import java.util.Locale;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Beta
public final class KiwiSlf4j {
    public static boolean isEnabled(Logger logger, String levelName) {
        return KiwiSlf4j.isEnabled(logger, KiwiSlf4j.toLevelIgnoreCase(levelName));
    }

    public static boolean isEnabled(Logger logger, Level level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ERROR -> logger.isErrorEnabled();
            case Level.WARN -> logger.isWarnEnabled();
            case Level.INFO -> logger.isInfoEnabled();
            case Level.DEBUG -> logger.isDebugEnabled();
            case Level.TRACE -> logger.isTraceEnabled();
        };
    }

    public static void log(Logger logger, String levelName, String message) {
        KiwiSlf4j.log(logger, KiwiSlf4j.toLevelIgnoreCase(levelName), message);
    }

    public static void log(Logger logger, Level level, String message) {
        switch (level) {
            case ERROR: {
                logger.error(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case INFO: {
                logger.info(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case TRACE: {
                logger.trace(message);
            }
        }
    }

    public static void log(Logger logger, String levelName, String format, Object arg) {
        KiwiSlf4j.log(logger, KiwiSlf4j.toLevelIgnoreCase(levelName), format, arg);
    }

    public static void log(Logger logger, Level level, String format, Object arg) {
        switch (level) {
            case ERROR: {
                logger.error(format, arg);
                break;
            }
            case WARN: {
                logger.warn(format, arg);
                break;
            }
            case INFO: {
                logger.info(format, arg);
                break;
            }
            case DEBUG: {
                logger.debug(format, arg);
                break;
            }
            case TRACE: {
                logger.trace(format, arg);
            }
        }
    }

    public static void log(Logger logger, String levelName, String format, Object arg1, Object arg2) {
        KiwiSlf4j.log(logger, KiwiSlf4j.toLevelIgnoreCase(levelName), format, arg1, arg2);
    }

    public static void log(Logger logger, Level level, String format, Object arg1, Object arg2) {
        switch (level) {
            case ERROR: {
                logger.error(format, arg1, arg2);
                break;
            }
            case WARN: {
                logger.warn(format, arg1, arg2);
                break;
            }
            case INFO: {
                logger.info(format, arg1, arg2);
                break;
            }
            case DEBUG: {
                logger.debug(format, arg1, arg2);
                break;
            }
            case TRACE: {
                logger.trace(format, arg1, arg2);
            }
        }
    }

    public static void log(Logger logger, String levelName, String format, Object ... arguments) {
        KiwiSlf4j.log(logger, KiwiSlf4j.toLevelIgnoreCase(levelName), format, arguments);
    }

    public static void log(Logger logger, Level level, String format, Object ... arguments) {
        switch (level) {
            case ERROR: {
                logger.error(format, arguments);
                break;
            }
            case WARN: {
                logger.warn(format, arguments);
                break;
            }
            case INFO: {
                logger.info(format, arguments);
                break;
            }
            case DEBUG: {
                logger.debug(format, arguments);
                break;
            }
            case TRACE: {
                logger.trace(format, arguments);
            }
        }
    }

    public static void log(Logger logger, String levelName, String message, Throwable t) {
        KiwiSlf4j.log(logger, KiwiSlf4j.toLevelIgnoreCase(levelName), message, t);
    }

    public static void log(Logger logger, Level level, String message, Throwable t) {
        switch (level) {
            case ERROR: {
                logger.error(message, t);
                break;
            }
            case WARN: {
                logger.warn(message, t);
                break;
            }
            case INFO: {
                logger.info(message, t);
                break;
            }
            case DEBUG: {
                logger.debug(message, t);
                break;
            }
            case TRACE: {
                logger.trace(message, t);
            }
        }
    }

    public static Level toLevelIgnoreCase(String levelNameString) {
        KiwiPreconditions.checkArgumentNotBlank((String)levelNameString, (String)"levelNameString must not be blank");
        return Level.valueOf((String)levelNameString.toUpperCase(Locale.ENGLISH));
    }

    @Generated
    private KiwiSlf4j() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

