/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.slf4j;

import com.google.common.annotations.Beta;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.beta.slf4j.KiwiSlf4j;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Beta
public class TimestampingLogger {
    private final Logger logger;
    private final String elapsedTimeTemplate;
    private final BiFunction<Long, Integer, Object[]> argumentTransformer;
    private final String initialMessage;
    private long previousTimestamp;
    private int logCount;

    public TimestampingLogger(Logger logger) {
        this(logger, 0L, null, null, false, null);
    }

    TimestampingLogger(Logger logger, long initialTimestamp, String elapsedTimeTemplate, BiFunction<Long, Integer, Object[]> argumentTransformer, boolean skipInitialMessage, String initialMessage) {
        this.logger = (Logger)KiwiPreconditions.requireNotNull((Object)logger);
        this.previousTimestamp = KiwiPreconditions.requirePositiveOrZero((long)initialTimestamp);
        this.logCount = 0;
        this.elapsedTimeTemplate = StringUtils.isBlank((CharSequence)elapsedTimeTemplate) ? "[elapsed time since previous: {} nanoseconds / {} millis]" : elapsedTimeTemplate;
        this.argumentTransformer = Objects.isNull(argumentTransformer) ? (nanos, count) -> new Object[]{nanos, TimestampingLogger.nanosToMillis(nanos)} : argumentTransformer;
        this.initialMessage = skipInitialMessage ? null : (StringUtils.isBlank((CharSequence)initialMessage) ? "[elapsed time since previous: N/A (no previous timestamp)]" : initialMessage);
    }

    private static long nanosToMillis(long diffInNanos) {
        return Duration.ofNanos(diffInNanos).toMillis();
    }

    public void traceLogElapsed(String message, Object ... args) {
        this.logElapsed(Level.TRACE, message, args);
    }

    public void debugLogElapsed(String message, Object ... args) {
        this.logElapsed(Level.DEBUG, message, args);
    }

    public void logElapsed(Level level, String message, Object ... args) {
        if (KiwiSlf4j.isEnabled(this.logger, level)) {
            long now = System.nanoTime();
            KiwiSlf4j.log(this.logger, level, message, args);
            this.logElapsedSincePreviousTimestamp(level, now);
            this.previousTimestamp = now;
            ++this.logCount;
        }
    }

    private void logElapsedSincePreviousTimestamp(Level level, long now) {
        if (this.previousTimestamp > 0L) {
            long diffInNanos = now - this.previousTimestamp;
            Object[] args = this.argumentTransformer.apply(diffInNanos, this.logCount);
            KiwiSlf4j.log(this.logger, level, this.elapsedTimeTemplate, args);
        } else if (StringUtils.isNotBlank((CharSequence)this.initialMessage)) {
            KiwiSlf4j.log(this.logger, level, this.initialMessage);
        }
    }

    public void traceLogAppendingElapsed(String message, Object ... args) {
        this.logAppendingElapsed(Level.TRACE, message, args);
    }

    public void debugLogAppendingElapsed(String message, Object ... args) {
        this.logAppendingElapsed(Level.DEBUG, message, args);
    }

    public void logAppendingElapsed(Level level, String message, Object ... args) {
        if (KiwiSlf4j.isEnabled(this.logger, level)) {
            long now = System.nanoTime();
            String formattedMessage = KiwiStrings.f((String)message, (Object[])args);
            this.logAppendingElapsedSincePreviousTimestamp(level, formattedMessage, now);
            this.previousTimestamp = now;
            ++this.logCount;
        }
    }

    private void logAppendingElapsedSincePreviousTimestamp(Level level, String formattedMessage, long now) {
        if (this.previousTimestamp > 0L) {
            long diffInNanos = now - this.previousTimestamp;
            Object[] args = this.argumentTransformer.apply(diffInNanos, this.logCount);
            String elapsedTimeMessage = KiwiStrings.f((String)this.elapsedTimeTemplate, (Object[])args);
            KiwiSlf4j.log(this.logger, level, formattedMessage + " " + elapsedTimeMessage);
        } else if (StringUtils.isBlank((CharSequence)this.initialMessage)) {
            KiwiSlf4j.log(this.logger, level, formattedMessage);
        } else {
            KiwiSlf4j.log(this.logger, level, formattedMessage + " " + this.initialMessage);
        }
    }

    @Generated
    public static TimestampingLoggerBuilder builder() {
        return new TimestampingLoggerBuilder();
    }

    @Generated
    public static class TimestampingLoggerBuilder {
        @Generated
        private Logger logger;
        @Generated
        private long initialTimestamp;
        @Generated
        private String elapsedTimeTemplate;
        @Generated
        private BiFunction<Long, Integer, Object[]> argumentTransformer;
        @Generated
        private boolean skipInitialMessage;
        @Generated
        private String initialMessage;

        @Generated
        TimestampingLoggerBuilder() {
        }

        @Generated
        public TimestampingLoggerBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        @Generated
        public TimestampingLoggerBuilder initialTimestamp(long initialTimestamp) {
            this.initialTimestamp = initialTimestamp;
            return this;
        }

        @Generated
        public TimestampingLoggerBuilder elapsedTimeTemplate(String elapsedTimeTemplate) {
            this.elapsedTimeTemplate = elapsedTimeTemplate;
            return this;
        }

        @Generated
        public TimestampingLoggerBuilder argumentTransformer(BiFunction<Long, Integer, Object[]> argumentTransformer) {
            this.argumentTransformer = argumentTransformer;
            return this;
        }

        @Generated
        public TimestampingLoggerBuilder skipInitialMessage(boolean skipInitialMessage) {
            this.skipInitialMessage = skipInitialMessage;
            return this;
        }

        @Generated
        public TimestampingLoggerBuilder initialMessage(String initialMessage) {
            this.initialMessage = initialMessage;
            return this;
        }

        @Generated
        public TimestampingLogger build() {
            return new TimestampingLogger(this.logger, this.initialTimestamp, this.elapsedTimeTemplate, this.argumentTransformer, this.skipInitialMessage, this.initialMessage);
        }

        @Generated
        public String toString() {
            return "TimestampingLogger.TimestampingLoggerBuilder(logger=" + String.valueOf(this.logger) + ", initialTimestamp=" + this.initialTimestamp + ", elapsedTimeTemplate=" + this.elapsedTimeTemplate + ", argumentTransformer=" + String.valueOf(this.argumentTransformer) + ", skipInitialMessage=" + this.skipInitialMessage + ", initialMessage=" + this.initialMessage + ")";
        }
    }
}

