/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beta.time;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.CheckReturnValue;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.time.StopWatch;
import org.kiwiproject.base.KiwiPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class Timing {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(Timing.class);
    private static final int MAX_WARNINGS_TO_LOG = 10;

    private static void logElapsedMillisChangeToNanosWarning(Class<?> clazz, AtomicInteger logCount) {
        if (logCount.get() >= 10) {
            return;
        }
        logCount.incrementAndGet();
        LOG.warn("In a future release, elapsedMillis in the {} constructor will change to elapsedNanos, and the constructor may become private! Any custom code using this directly should be changed to use 'ofElapsedMillis' to ensure that it continues to report correct results after the constructor changes. Or, use 'ofElapsedNanos' and pass nanoseconds as the argument.", (Object)clazz.getName());
    }

    @CheckReturnValue
    public static <R> TimedWithResult<R> timeWithResult(StopWatch stopWatch, Supplier<R> operation) {
        R result;
        stopWatch.reset();
        stopWatch.start();
        try {
            result = operation.get();
        }
        finally {
            stopWatch.stop();
        }
        return TimedWithResult.ofElapsedNanos(stopWatch.getNanoTime(), result);
    }

    @CheckReturnValue
    public static TimedNoResult timeNoResult(StopWatch stopWatch, Runnable operation) {
        stopWatch.reset();
        stopWatch.start();
        try {
            operation.run();
        }
        finally {
            stopWatch.stop();
        }
        return TimedNoResult.ofElapsedNanos(stopWatch.getNanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public static <R> TimedWithErrorOrResult<R> timeWithResult(Supplier<R> operation) {
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            R result = operation.get();
            TimedWithErrorOrResult<R> timedWithErrorOrResult = TimedWithErrorOrResult.ofResult(stopWatch.getNanoTime(), result);
            return timedWithErrorOrResult;
        }
        catch (RuntimeException e) {
            TimedWithErrorOrResult timedWithErrorOrResult = TimedWithErrorOrResult.ofException(stopWatch.getNanoTime(), e);
            return timedWithErrorOrResult;
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public static TimedWithErrorNoResult timeNoResult(Runnable operation) {
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            operation.run();
            TimedWithErrorNoResult timedWithErrorNoResult = TimedWithErrorNoResult.ofSuccess(stopWatch.getNanoTime());
            return timedWithErrorNoResult;
        }
        catch (RuntimeException e) {
            TimedWithErrorNoResult timedWithErrorNoResult = TimedWithErrorNoResult.ofException(stopWatch.getNanoTime(), e);
            return timedWithErrorNoResult;
        }
        finally {
            stopWatch.stop();
        }
    }

    @Generated
    private Timing() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class TimedWithResult<R>
    implements Timed {
        private static final AtomicInteger LOG_COUNT = new AtomicInteger();
        private final long elapsedMillis;
        private final long elapsedNanos;
        private final R result;

        @ConstructorProperties(value={"elapsedMillis", "result"})
        public TimedWithResult(long elapsedMillis, R result) {
            Timing.logElapsedMillisChangeToNanosWarning(TimedWithResult.class, LOG_COUNT);
            this.elapsedMillis = elapsedMillis;
            this.elapsedNanos = TimeUnit.MILLISECONDS.toNanos(elapsedMillis);
            this.result = result;
        }

        public static <R> TimedWithResult<R> ofElapsedMillis(long elapsedMillis, R result) {
            return new TimedWithResult<R>(elapsedMillis, result);
        }

        public static <R> TimedWithResult<R> ofElapsedNanos(long elapsedNanos, R result) {
            return new TimedWithResult<R>(TimeUnit.NANOSECONDS.toMillis(elapsedNanos), result);
        }

        @Override
        public long getElapsedNanos() {
            return this.elapsedNanos;
        }

        @Override
        @Generated
        public long getElapsedMillis() {
            return this.elapsedMillis;
        }

        @Generated
        public R getResult() {
            return this.result;
        }

        @Generated
        public String toString() {
            return "Timing.TimedWithResult(elapsedMillis=" + this.getElapsedMillis() + ", elapsedNanos=" + this.getElapsedNanos() + ", result=" + String.valueOf(this.getResult()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimedWithResult)) {
                return false;
            }
            TimedWithResult other = (TimedWithResult)o;
            if (this.getElapsedMillis() != other.getElapsedMillis()) {
                return false;
            }
            if (this.getElapsedNanos() != other.getElapsedNanos()) {
                return false;
            }
            R this$result = this.getResult();
            R other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $elapsedMillis = this.getElapsedMillis();
            result = result * 59 + (int)($elapsedMillis >>> 32 ^ $elapsedMillis);
            long $elapsedNanos = this.getElapsedNanos();
            result = result * 59 + (int)($elapsedNanos >>> 32 ^ $elapsedNanos);
            R $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }
    }

    public static final class TimedNoResult
    implements Timed {
        private static final AtomicInteger LOG_COUNT = new AtomicInteger();
        private final long elapsedMillis;
        private final long elapsedNanos;

        @ConstructorProperties(value={"elapsedMillis"})
        public TimedNoResult(long elapsedMillis) {
            Timing.logElapsedMillisChangeToNanosWarning(TimedNoResult.class, LOG_COUNT);
            this.elapsedMillis = elapsedMillis;
            this.elapsedNanos = TimeUnit.MILLISECONDS.toNanos(elapsedMillis);
        }

        public static TimedNoResult ofElapsedMillis(long elapsedMillis) {
            return new TimedNoResult(elapsedMillis);
        }

        public static TimedNoResult ofElapsedNanos(long elapsedNanos) {
            return new TimedNoResult(TimeUnit.NANOSECONDS.toMillis(elapsedNanos));
        }

        @Override
        public long getElapsedNanos() {
            return this.elapsedNanos;
        }

        @Override
        @Generated
        public long getElapsedMillis() {
            return this.elapsedMillis;
        }

        @Generated
        public String toString() {
            return "Timing.TimedNoResult(elapsedMillis=" + this.getElapsedMillis() + ", elapsedNanos=" + this.getElapsedNanos() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimedNoResult)) {
                return false;
            }
            TimedNoResult other = (TimedNoResult)o;
            if (this.getElapsedMillis() != other.getElapsedMillis()) {
                return false;
            }
            return this.getElapsedNanos() == other.getElapsedNanos();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $elapsedMillis = this.getElapsedMillis();
            result = result * 59 + (int)($elapsedMillis >>> 32 ^ $elapsedMillis);
            long $elapsedNanos = this.getElapsedNanos();
            result = result * 59 + (int)($elapsedNanos >>> 32 ^ $elapsedNanos);
            return result;
        }
    }

    public static final class TimedWithErrorOrResult<R>
    implements TimedWithError {
        private final long elapsedNanos;
        private final R result;
        private final RuntimeException exception;

        @VisibleForTesting
        TimedWithErrorOrResult(long elapsedNanos, R result, RuntimeException exception) {
            if (Objects.nonNull(result) && Objects.nonNull(exception)) {
                throw new IllegalArgumentException("Cannot contain a result and an exception");
            }
            this.elapsedNanos = elapsedNanos;
            this.result = result;
            this.exception = exception;
        }

        public static <R> TimedWithErrorOrResult<R> ofResult(long elapsedNanos, R result) {
            return new TimedWithErrorOrResult<R>(elapsedNanos, result, null);
        }

        public static <R> TimedWithErrorOrResult<R> ofException(long elapsedNanos, RuntimeException exception) {
            KiwiPreconditions.checkArgumentNotNull((Object)exception, (String)"exception must not be null");
            return new TimedWithErrorOrResult<Object>(elapsedNanos, null, exception);
        }

        public boolean hasResult() {
            return this.operationSucceeded();
        }

        public Optional<R> getResult() {
            return Optional.ofNullable(this.result);
        }

        public boolean isNullResult() {
            return this.operationSucceeded() && this.getResult().isEmpty();
        }

        @Override
        public Optional<RuntimeException> getException() {
            return Optional.ofNullable(this.exception);
        }

        @Override
        @Generated
        public long getElapsedNanos() {
            return this.elapsedNanos;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimedWithErrorOrResult)) {
                return false;
            }
            TimedWithErrorOrResult other = (TimedWithErrorOrResult)o;
            if (this.getElapsedNanos() != other.getElapsedNanos()) {
                return false;
            }
            Optional<R> this$result = this.getResult();
            Optional<R> other$result = other.getResult();
            if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
                return false;
            }
            Optional<RuntimeException> this$exception = this.getException();
            Optional<RuntimeException> other$exception = other.getException();
            return !(this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $elapsedNanos = this.getElapsedNanos();
            result = result * 59 + (int)($elapsedNanos >>> 32 ^ $elapsedNanos);
            Optional<R> $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            Optional<RuntimeException> $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Timing.TimedWithErrorOrResult(elapsedNanos=" + this.getElapsedNanos() + ", result=" + String.valueOf(this.getResult()) + ", exception=" + String.valueOf(this.getException()) + ")";
        }
    }

    public static final class TimedWithErrorNoResult
    implements TimedWithError {
        private final long elapsedNanos;
        private final RuntimeException exception;

        public static TimedWithErrorNoResult ofSuccess(long elapsedNanos) {
            return new TimedWithErrorNoResult(elapsedNanos, null);
        }

        public static TimedWithErrorNoResult ofException(long elapsedNanos, RuntimeException exception) {
            KiwiPreconditions.checkArgumentNotNull((Object)exception, (String)"exception must not be null");
            return new TimedWithErrorNoResult(elapsedNanos, exception);
        }

        @Override
        public Optional<RuntimeException> getException() {
            return Optional.ofNullable(this.exception);
        }

        @Override
        @Generated
        public long getElapsedNanos() {
            return this.elapsedNanos;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimedWithErrorNoResult)) {
                return false;
            }
            TimedWithErrorNoResult other = (TimedWithErrorNoResult)o;
            if (this.getElapsedNanos() != other.getElapsedNanos()) {
                return false;
            }
            Optional<RuntimeException> this$exception = this.getException();
            Optional<RuntimeException> other$exception = other.getException();
            return !(this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $elapsedNanos = this.getElapsedNanos();
            result = result * 59 + (int)($elapsedNanos >>> 32 ^ $elapsedNanos);
            Optional<RuntimeException> $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Timing.TimedWithErrorNoResult(elapsedNanos=" + this.getElapsedNanos() + ", exception=" + String.valueOf(this.getException()) + ")";
        }

        @ConstructorProperties(value={"elapsedNanos", "exception"})
        @Generated
        private TimedWithErrorNoResult(long elapsedNanos, RuntimeException exception) {
            this.elapsedNanos = elapsedNanos;
            this.exception = exception;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TimedWithError {
        public long getElapsedNanos();

        default public long getElapsedMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.getElapsedNanos());
        }

        default public boolean operationSucceeded() {
            return !this.hasException();
        }

        default public boolean hasException() {
            return this.getException().isPresent();
        }

        public Optional<RuntimeException> getException();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Timed {
        public long getElapsedMillis();

        public long getElapsedNanos();
    }
}

