/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import java.lang.management.ManagementFactory;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.kiwiproject.base.KiwiEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEnvironment
implements KiwiEnvironment {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEnvironment.class);

    @Override
    public Date currentDate() {
        return Date.from(Instant.now());
    }

    @Override
    public Time currentTime() {
        return new Time(System.currentTimeMillis());
    }

    @Override
    public Timestamp currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    @Override
    public Instant currentInstant() {
        return Instant.now();
    }

    @Override
    public Instant currentInstant(ZoneId zone) {
        return Instant.now(Clock.system(zone));
    }

    @Override
    public LocalDate currentLocalDate() {
        return LocalDate.now();
    }

    @Override
    public LocalDate currentLocalDate(ZoneId zone) {
        return LocalDate.now(zone);
    }

    @Override
    public LocalTime currentLocalTime() {
        return LocalTime.now();
    }

    @Override
    public LocalTime currentLocalTime(ZoneId zone) {
        return LocalTime.now(zone);
    }

    @Override
    public LocalDateTime currentLocalDateTime() {
        return LocalDateTime.now();
    }

    @Override
    public LocalDateTime currentLocalDateTime(ZoneId zone) {
        return LocalDateTime.now(zone);
    }

    @Override
    public ZonedDateTime currentZonedDateTimeUTC() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    @Override
    public ZonedDateTime currentZonedDateTime(ZoneId zone) {
        return ZonedDateTime.now(zone);
    }

    @Override
    public ZonedDateTime currentZonedDateTime() {
        return ZonedDateTime.now();
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    @Override
    public String currentProcessId() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    @Override
    public Optional<Integer> tryGetCurrentProcessId() {
        try {
            String value = this.currentProcessId();
            return Optional.of(Integer.parseInt(value));
        }
        catch (Exception e) {
            LOG.trace("Unable to get current process ID", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void sleep(long milliseconds) throws InterruptedException {
        Thread.sleep(milliseconds);
    }

    @Override
    public void sleep(long timeout, TimeUnit unit) throws InterruptedException {
        unit.sleep(timeout);
    }

    @Override
    public void sleep(long millis, int nanos) throws InterruptedException {
        Thread.sleep(millis, nanos);
    }

    @Override
    public boolean sleepQuietly(long milliseconds) {
        try {
            this.sleep(milliseconds);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted sleeping for {} milliseconds", (Object)milliseconds);
            Thread.currentThread().interrupt();
            return true;
        }
    }

    @Override
    public boolean sleepQuietly(long timeout, TimeUnit unit) {
        try {
            this.sleep(timeout, unit);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted sleeping for {} {}", (Object)timeout, (Object)unit);
            Thread.currentThread().interrupt();
            return true;
        }
    }

    @Override
    public boolean sleepQuietly(long millis, int nanos) {
        try {
            this.sleep(millis, nanos);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted sleeping for {} milliseconds with {} nanos", (Object)millis, (Object)nanos);
            Thread.currentThread().interrupt();
            return true;
        }
    }

    @Override
    public String getenv(String name) {
        return System.getenv(name);
    }

    @Override
    public Map<String, String> getenv() {
        return System.getenv();
    }

    @Override
    public Properties getProperties() {
        return System.getProperties();
    }

    @Override
    public String getProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }
}

