/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;

public final class KiwiProperties {
    public static Properties newProperties(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        List strings = Lists.newArrayList((Object[])items).stream().map(Object::toString).collect(Collectors.toList());
        List kvPairs = Lists.partition(strings, (int)2);
        return KiwiProperties.newPropertiesFromStringPairs(kvPairs);
    }

    public static Properties newProperties(String ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        List kvPairs = Lists.partition((List)Lists.newArrayList((Object[])items), (int)2);
        return KiwiProperties.newPropertiesFromStringPairs(kvPairs);
    }

    public static Properties newProperties(List<String> items) {
        KiwiPreconditions.checkEvenItemCount(items);
        List kvPairs = Lists.partition(items, (int)2);
        return KiwiProperties.newPropertiesFromStringPairs(kvPairs);
    }

    public static Properties newProperties(Map<String, String> map) {
        Objects.requireNonNull(map);
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    public static Properties newPropertiesFromStringPairs(List<List<String>> items) {
        Objects.requireNonNull(items);
        return items.stream().collect(Properties::new, KiwiProperties::checkPairAndAccumulate, Properties::putAll);
    }

    private static void checkPairAndAccumulate(Properties accumulator, List<String> pair) {
        Preconditions.checkArgument((pair.size() >= 2 ? 1 : 0) != 0, (Object)"Each sublist must contain at least 2 items (additional elements are ignored but won't cause an error)");
        accumulator.setProperty(KiwiLists.first(pair), KiwiLists.second(pair));
    }

    @Generated
    private KiwiProperties() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

