/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.config;

import io.dropwizard.client.ssl.TlsConfiguration;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.config.SSLContextConfiguration;
import org.kiwiproject.security.KeyAndTrustStoreConfigProvider;
import org.kiwiproject.security.KeyStoreType;
import org.kiwiproject.security.SSLContextProtocol;

public class TlsContextConfiguration
implements KeyAndTrustStoreConfigProvider {
    @NotBlank
    private String protocol;
    private String keyStorePath;
    private String keyStorePassword;
    @NotBlank
    private String keyStoreType;
    @NotBlank
    private String trustStorePath;
    @NotNull
    private String trustStorePassword;
    @NotBlank
    private String trustStoreType;
    private boolean verifyHostname;
    private List<String> supportedProtocols;

    public static TlsContextConfiguration fromDropwizardTlsConfiguration(TlsConfiguration tlsConfig) {
        KiwiPreconditions.checkArgumentNotNull(tlsConfig, "TlsConfiguration cannot be null");
        return TlsContextConfiguration.builder().protocol(tlsConfig.getProtocol()).keyStorePath(TlsContextConfiguration.absolutePathOrNull(tlsConfig.getKeyStorePath())).keyStorePassword(tlsConfig.getKeyStorePassword()).keyStoreType(tlsConfig.getKeyStoreType()).trustStorePath(TlsContextConfiguration.absolutePathOrNull(tlsConfig.getTrustStorePath())).trustStorePassword(tlsConfig.getTrustStorePassword()).trustStoreType(tlsConfig.getTrustStoreType()).verifyHostname(tlsConfig.isVerifyHostname()).supportedProtocols(tlsConfig.getSupportedProtocols()).build();
    }

    private static String absolutePathOrNull(@Nullable File nullableFile) {
        return Optional.ofNullable(nullableFile).map(File::getAbsolutePath).orElse(null);
    }

    public TlsConfiguration toDropwizardTlsConfiguration() {
        TlsConfiguration tlsConfig = new TlsConfiguration();
        tlsConfig.setProtocol(this.protocol);
        File keyStoreFile = Optional.ofNullable(this.keyStorePath).map(File::new).orElse(null);
        tlsConfig.setKeyStorePath(keyStoreFile);
        tlsConfig.setKeyStorePassword(this.keyStorePassword);
        tlsConfig.setKeyStoreType(this.keyStoreType);
        tlsConfig.setTrustStorePath(new File(this.trustStorePath));
        tlsConfig.setTrustStorePassword(this.trustStorePassword);
        tlsConfig.setTrustStoreType(this.trustStoreType);
        tlsConfig.setVerifyHostname(this.verifyHostname);
        tlsConfig.setSupportedProtocols(this.supportedProtocols);
        return tlsConfig;
    }

    public SSLContextConfiguration toSslContextConfiguration() {
        return SSLContextConfiguration.builder().keyStorePath(this.keyStorePath).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).trustStorePath(this.trustStorePath).trustStorePassword(this.trustStorePassword).protocol(this.protocol).verifyHostname(this.verifyHostname).build();
    }

    @Generated
    private static String $default$protocol() {
        return SSLContextProtocol.TLS_1_2.value;
    }

    @Generated
    private static String $default$keyStoreType() {
        return KeyStoreType.JKS.value;
    }

    @Generated
    private static String $default$trustStoreType() {
        return KeyStoreType.JKS.value;
    }

    @Generated
    private static boolean $default$verifyHostname() {
        return true;
    }

    @Generated
    public static TlsContextConfigurationBuilder builder() {
        return new TlsContextConfigurationBuilder();
    }

    @Override
    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    @Generated
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    @Generated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Override
    @Generated
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    @Generated
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    @Generated
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Override
    @Generated
    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    @Generated
    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @Generated
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Generated
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @Generated
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @Generated
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Generated
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @Generated
    public void setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    @Generated
    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    @Generated
    public TlsContextConfiguration() {
        this.protocol = TlsContextConfiguration.$default$protocol();
        this.keyStoreType = TlsContextConfiguration.$default$keyStoreType();
        this.trustStoreType = TlsContextConfiguration.$default$trustStoreType();
        this.verifyHostname = TlsContextConfiguration.$default$verifyHostname();
    }

    @ConstructorProperties(value={"protocol", "keyStorePath", "keyStorePassword", "keyStoreType", "trustStorePath", "trustStorePassword", "trustStoreType", "verifyHostname", "supportedProtocols"})
    @Generated
    private TlsContextConfiguration(String protocol, String keyStorePath, String keyStorePassword, String keyStoreType, String trustStorePath, String trustStorePassword, String trustStoreType, boolean verifyHostname, List<String> supportedProtocols) {
        this.protocol = protocol;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        this.verifyHostname = verifyHostname;
        this.supportedProtocols = supportedProtocols;
    }

    @Generated
    public String toString() {
        return "TlsContextConfiguration(protocol=" + this.getProtocol() + ", keyStorePath=" + this.getKeyStorePath() + ", keyStoreType=" + this.getKeyStoreType() + ", trustStorePath=" + this.getTrustStorePath() + ", trustStoreType=" + this.getTrustStoreType() + ", verifyHostname=" + this.isVerifyHostname() + ", supportedProtocols=" + this.getSupportedProtocols() + ")";
    }

    @Generated
    public static class TlsContextConfigurationBuilder {
        @Generated
        private boolean protocol$set;
        @Generated
        private String protocol$value;
        @Generated
        private String keyStorePath;
        @Generated
        private String keyStorePassword;
        @Generated
        private boolean keyStoreType$set;
        @Generated
        private String keyStoreType$value;
        @Generated
        private String trustStorePath;
        @Generated
        private String trustStorePassword;
        @Generated
        private boolean trustStoreType$set;
        @Generated
        private String trustStoreType$value;
        @Generated
        private boolean verifyHostname$set;
        @Generated
        private boolean verifyHostname$value;
        @Generated
        private List<String> supportedProtocols;

        @Generated
        TlsContextConfigurationBuilder() {
        }

        @Generated
        public TlsContextConfigurationBuilder protocol(String protocol) {
            this.protocol$value = protocol;
            this.protocol$set = true;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder keyStoreType(String keyStoreType) {
            this.keyStoreType$value = keyStoreType;
            this.keyStoreType$set = true;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder trustStoreType(String trustStoreType) {
            this.trustStoreType$value = trustStoreType;
            this.trustStoreType$set = true;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder verifyHostname(boolean verifyHostname) {
            this.verifyHostname$value = verifyHostname;
            this.verifyHostname$set = true;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder supportedProtocols(List<String> supportedProtocols) {
            this.supportedProtocols = supportedProtocols;
            return this;
        }

        @Generated
        public TlsContextConfiguration build() {
            String protocol$value = this.protocol$value;
            if (!this.protocol$set) {
                protocol$value = TlsContextConfiguration.$default$protocol();
            }
            String keyStoreType$value = this.keyStoreType$value;
            if (!this.keyStoreType$set) {
                keyStoreType$value = TlsContextConfiguration.$default$keyStoreType();
            }
            String trustStoreType$value = this.trustStoreType$value;
            if (!this.trustStoreType$set) {
                trustStoreType$value = TlsContextConfiguration.$default$trustStoreType();
            }
            boolean verifyHostname$value = this.verifyHostname$value;
            if (!this.verifyHostname$set) {
                verifyHostname$value = TlsContextConfiguration.$default$verifyHostname();
            }
            return new TlsContextConfiguration(protocol$value, this.keyStorePath, this.keyStorePassword, keyStoreType$value, this.trustStorePath, this.trustStorePassword, trustStoreType$value, verifyHostname$value, this.supportedProtocols);
        }

        @Generated
        public String toString() {
            return "TlsContextConfiguration.TlsContextConfigurationBuilder(protocol$value=" + this.protocol$value + ", keyStorePath=" + this.keyStorePath + ", keyStorePassword=" + this.keyStorePassword + ", keyStoreType$value=" + this.keyStoreType$value + ", trustStorePath=" + this.trustStorePath + ", trustStorePassword=" + this.trustStorePassword + ", trustStoreType$value=" + this.trustStoreType$value + ", verifyHostname$value=" + this.verifyHostname$value + ", supportedProtocols=" + this.supportedProtocols + ")";
        }
    }
}

