/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.hibernate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Order;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiLists;

public final class CriteriaQueries {
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    private static final int ORDER_SPEC_SIZE_WITH_ORDER = 2;
    private static final int ORDER_SPEC_SIZE_WITHOUT_ORDER = 1;
    private static final String INVALID_ORDER_SPEC_MESSAGE_TEMPLATE = "'%s' is not a valid order specification. Must contain a property name optionally followed by (case-insensitive) asc or desc";

    public static Criteria distinctCriteria(Session session, Class<?> persistentClass, String orderClause, String ... fetchAssociations) {
        Criteria criteria = CriteriaQueries.distinctCriteriaWithOrder(session, persistentClass, orderClause);
        CriteriaQueries.addFetchAssociations(criteria, fetchAssociations);
        return criteria;
    }

    public static Criteria distinctCriteriaWithOrder(Session session, Class<?> persistentClass, String orderClause) {
        Criteria criteria = CriteriaQueries.distinctCriteria(session, persistentClass);
        return CriteriaQueries.addOrder(criteria, orderClause);
    }

    public static Criteria distinctCriteriaWithFetchAssociations(Session session, Class<?> persistentClass, String ... fetchAssociations) {
        Criteria criteria = CriteriaQueries.distinctCriteria(session, persistentClass);
        CriteriaQueries.addFetchAssociations(criteria, fetchAssociations);
        return criteria;
    }

    public static Criteria distinctCriteria(Session session, Class<?> persistentClass) {
        return session.createCriteria(persistentClass).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
    }

    private static void addFetchAssociations(Criteria criteria, String ... fetchAssociations) {
        for (String association : fetchAssociations) {
            criteria.setFetchMode(association, FetchMode.JOIN);
        }
    }

    public static Criteria addOrder(Criteria criteria, String orderClause) {
        if (StringUtils.isBlank((CharSequence)orderClause)) {
            return criteria;
        }
        CriteriaQueries.splitToList(orderClause, ',').stream().map(CriteriaQueries::toOrderFromPropertyOrderClause).forEach(arg_0 -> ((Criteria)criteria).addOrder(arg_0));
        return criteria;
    }

    @VisibleForTesting
    static Order toOrderFromPropertyOrderClause(String propertyOrdering) {
        List<String> orderSpec = CriteriaQueries.splitToList(propertyOrdering, ' ');
        CriteriaQueries.validateOrderSpecification(orderSpec, propertyOrdering);
        String propertyName = KiwiLists.first(orderSpec);
        boolean isAscending = orderSpec.size() < 2 || ASC.equalsIgnoreCase(KiwiLists.second(orderSpec));
        return isAscending ? Order.asc((String)propertyName) : Order.desc((String)propertyName);
    }

    private static void validateOrderSpecification(List<String> orderSpec, String rawPropertyOrder) {
        Preconditions.checkArgument((orderSpec.size() == 1 || orderSpec.size() == 2 ? 1 : 0) != 0, (String)INVALID_ORDER_SPEC_MESSAGE_TEMPLATE, (Object)rawPropertyOrder);
        if (orderSpec.size() == 2) {
            String order = KiwiLists.second(orderSpec);
            Preconditions.checkArgument((ASC.equalsIgnoreCase(order) || DESC.equalsIgnoreCase(order) ? 1 : 0) != 0, (String)"'%s' is not a valid order. Property order must be either %s or %s (case-insensitive)", (Object)order, (Object)ASC, (Object)DESC);
        }
    }

    private static List<String> splitToList(String value, char separator) {
        return Lists.newArrayList(KiwiStrings.splitWithTrimAndOmitEmpty((CharSequence)value, separator));
    }

    @Generated
    private CriteriaQueries() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

