/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.hibernate.usertype;

import java.io.Serializable;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;
import org.kiwiproject.collect.KiwiArrays;

public abstract class AbstractArrayUserType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{2003};

    public abstract String databaseTypeName();

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public boolean equals(Object ol, Object o2) throws HibernateException {
        return Objects.equals(ol, o2);
    }

    public int hashCode(Object obj) throws HibernateException {
        return Objects.isNull(obj) ? 0 : obj.hashCode();
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        if (KiwiArrays.isNullOrEmpty(names) || Objects.isNull(resultSet) || Objects.isNull(resultSet.getArray(names[0]))) {
            return null;
        }
        return resultSet.getArray(names[0]).getArray();
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (Objects.isNull(value)) {
            statement.setNull(index, SQL_TYPES[0]);
        } else {
            Object[] castObject = (Object[])value;
            Array sqlArray = session.connection().createArrayOf(this.databaseTypeName(), castObject);
            statement.setArray(index, sqlArray);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return Objects.isNull(value) ? null : ((Object[])value).clone();
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

