/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.mongo;

import com.google.common.annotations.Beta;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

@Beta
public class MongoClientWrapper
implements Closeable {
    private final MongoClient mongoClient;
    private final MongoDatabase mongoDatabase;
    private final DB db;

    public MongoClientWrapper(String mongoUri, String databaseName) {
        KiwiPreconditions.checkArgumentNotBlank(mongoUri, "mongoUri cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(databaseName, "databaseName cannot be blank");
        this.mongoClient = new MongoClient(new MongoClientURI(mongoUri));
        this.mongoDatabase = this.mongoClient.getDatabase(databaseName);
        this.db = this.mongoClient.getDB(databaseName);
    }

    public DB getDB() {
        return this.db;
    }

    @Override
    public void close() {
        this.mongoClient.close();
    }

    @Generated
    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    @Generated
    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }
}

