/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.net;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SimpleHostAndPort {
    private final String host;
    private final int port;

    public static SimpleHostAndPort from(String hostPortString, String defaultHost, int defaultPort) {
        if (StringUtils.isBlank((CharSequence)hostPortString)) {
            return new SimpleHostAndPort(defaultHost, defaultPort);
        }
        return SimpleHostAndPort.from(hostPortString);
    }

    public static SimpleHostAndPort from(String hostPortString) {
        String[] split = hostPortString.split(":");
        Preconditions.checkState((split.length == 2 ? 1 : 0) != 0, (String)"%s is not in format host:port", (Object)hostPortString);
        return new SimpleHostAndPort(split[0], Integer.parseInt(split[1], 10));
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleHostAndPort)) {
            return false;
        }
        SimpleHostAndPort other = (SimpleHostAndPort)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleHostAndPort;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @ConstructorProperties(value={"host", "port"})
    @Generated
    private SimpleHostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

