/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.spring.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.spring.data.KiwiSort;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KiwiPage<T> {
    private List<T> content;
    private long size;
    private long number;
    private long numberOfElements;
    private long totalPages;
    private long totalElements;
    private KiwiSort sort;
    private int pagingStartsWith = 0;

    public static <T> KiwiPage<T> of(long pageNum, long limit, long total, List<T> contentList) {
        KiwiPreconditions.checkPositiveOrZero(pageNum);
        KiwiPreconditions.checkPositive(limit);
        KiwiPreconditions.checkPositiveOrZero(total);
        KiwiPreconditions.checkArgumentNotNull(contentList);
        KiwiPage<T> page = new KiwiPage<T>();
        page.setContent(contentList);
        page.setSize(limit);
        page.setNumber(pageNum);
        page.setNumberOfElements(contentList.size());
        page.setTotalElements(total);
        page.setTotalPages((long)Math.ceil((double)total / (double)limit));
        return page;
    }

    public KiwiPage<T> addKiwiSort(KiwiSort sort) {
        this.setSort(sort);
        return this;
    }

    public KiwiPage<T> usingZeroAsFirstPage() {
        this.setPagingStartsWith(0);
        return this;
    }

    public KiwiPage<T> usingOneAsFirstPage() {
        this.setPagingStartsWith(1);
        return this;
    }

    public boolean isFirst() {
        return this.number == (long)this.pagingStartsWith;
    }

    public boolean isLast() {
        int offset = 1 - this.pagingStartsWith;
        return this.number == this.totalPages - (long)offset;
    }

    public boolean isSorted() {
        return Objects.nonNull(this.sort);
    }

    @Generated
    public List<T> getContent() {
        return this.content;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public long getNumber() {
        return this.number;
    }

    @Generated
    public long getNumberOfElements() {
        return this.numberOfElements;
    }

    @Generated
    public long getTotalPages() {
        return this.totalPages;
    }

    @Generated
    public long getTotalElements() {
        return this.totalElements;
    }

    @Generated
    public KiwiSort getSort() {
        return this.sort;
    }

    @Generated
    public int getPagingStartsWith() {
        return this.pagingStartsWith;
    }

    @Generated
    public void setContent(List<T> content) {
        this.content = content;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @Generated
    public void setNumber(long number) {
        this.number = number;
    }

    @Generated
    public void setNumberOfElements(long numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    @Generated
    public void setTotalPages(long totalPages) {
        this.totalPages = totalPages;
    }

    @Generated
    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    @Generated
    public void setSort(KiwiSort sort) {
        this.sort = sort;
    }

    @Generated
    public void setPagingStartsWith(int pagingStartsWith) {
        this.pagingStartsWith = pagingStartsWith;
    }

    @Generated
    public String toString() {
        return "KiwiPage(size=" + this.getSize() + ", number=" + this.getNumber() + ", numberOfElements=" + this.getNumberOfElements() + ", totalPages=" + this.getTotalPages() + ", totalElements=" + this.getTotalElements() + ", sort=" + this.getSort() + ", pagingStartsWith=" + this.getPagingStartsWith() + ")";
    }
}

