/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

public final class KiwiDateTimeConverters {
    public static Date toDate(LocalDate localDate) {
        KiwiPreconditions.checkArgumentNotNull(localDate);
        return KiwiDateTimeConverters.toDate(localDate.atStartOfDay());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        KiwiPreconditions.checkArgumentNotNull(localDateTime);
        return Date.from(localDateTime.toInstant(ZoneOffset.UTC));
    }

    public static Date toDate(ZonedDateTime zonedDateTime) {
        KiwiPreconditions.checkArgumentNotNull(zonedDateTime);
        return Date.from(zonedDateTime.toInstant());
    }

    public static LocalDate toLocalDateUTC(Date date) {
        return KiwiDateTimeConverters.toLocalDate(date, ZoneOffset.UTC);
    }

    public static LocalDate toLocalDate(Date date, ZoneId zoneId) {
        KiwiPreconditions.checkArgumentNotNull(date);
        KiwiPreconditions.checkArgumentNotNull(zoneId);
        return date.toInstant().atZone(zoneId).toLocalDate();
    }

    public static LocalDateTime toLocalDateTimeUTC(Date date) {
        return KiwiDateTimeConverters.toLocalDateTime(date, ZoneOffset.UTC);
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneId zoneId) {
        KiwiPreconditions.checkArgumentNotNull(date);
        KiwiPreconditions.checkArgumentNotNull(zoneId);
        return date.toInstant().atZone(zoneId).toLocalDateTime();
    }

    public static ZonedDateTime toZonedDateTimeUTC(Date date) {
        return KiwiDateTimeConverters.toZonedDateTime(date, ZoneOffset.UTC);
    }

    public static ZonedDateTime toZonedDateTime(Date date, ZoneId zoneId) {
        KiwiPreconditions.checkArgumentNotNull(date);
        KiwiPreconditions.checkArgumentNotNull(zoneId);
        return date.toInstant().atZone(zoneId);
    }

    @Generated
    private KiwiDateTimeConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

