/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

public final class KiwiDateTimeFormatters {
    public static String formatAsIsoLocalDateUTC(Date date) {
        return KiwiDateTimeFormatters.formatWithUTC(date, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String formatAsIsoLocalDate(Date date, ZoneId targetZoneId) {
        return KiwiDateTimeFormatters.formatWith(date, targetZoneId, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String formatAsIsoLocalDate(TemporalAccessor dateTime) {
        return KiwiDateTimeFormatters.formatWith(dateTime, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String formatAsIsoLocalDateTimeUTC(Date date) {
        return KiwiDateTimeFormatters.formatWithUTC(date, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static String formatAsIsoLocalDateTime(Date date, ZoneId targetZoneId) {
        return KiwiDateTimeFormatters.formatWith(date, targetZoneId, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static String formatAsIsoLocalDateTime(LocalDate localDate) {
        return KiwiDateTimeFormatters.formatWith(localDate.atStartOfDay(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static String formatAsIsoLocalDateTime(TemporalAccessor dateTime) {
        return KiwiDateTimeFormatters.formatWith(dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static String formatAsIsoZonedDateTimeUTC(Date date) {
        return KiwiDateTimeFormatters.formatAsIsoZonedDateTime(date, (ZoneId)ZoneOffset.UTC);
    }

    public static String formatAsIsoZonedDateTime(Date date, ZoneId targetZoneId) {
        return KiwiDateTimeFormatters.formatWith(date, targetZoneId, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static String formatAsIsoZonedDateTimeUTC(LocalDate localDate) {
        return KiwiDateTimeFormatters.formatAsIsoZonedDateTimeUTC(localDate.atStartOfDay());
    }

    public static String formatAsIsoZonedDateTime(LocalDate localDate, ZoneId targetZoneId) {
        return KiwiDateTimeFormatters.formatAsIsoZonedDateTime(localDate.atStartOfDay(), targetZoneId);
    }

    public static String formatAsIsoZonedDateTimeUTC(LocalDateTime localDateTime) {
        return KiwiDateTimeFormatters.formatAsIsoZonedDateTime(localDateTime, (ZoneId)ZoneOffset.UTC);
    }

    public static String formatAsIsoZonedDateTime(LocalDateTime localDateTime, ZoneId targetZoneId) {
        return KiwiDateTimeFormatters.formatWith(localDateTime, targetZoneId, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static String formatAsIsoZonedDateTimeUTC(ZonedDateTime zonedDateTime) {
        return KiwiDateTimeFormatters.formatAsIsoZonedDateTime(zonedDateTime, (ZoneId)ZoneOffset.UTC);
    }

    public static String formatAsIsoZonedDateTime(ZonedDateTime zonedDateTime, ZoneId targetZoneId) {
        return KiwiDateTimeFormatters.formatWith(zonedDateTime, targetZoneId, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static String formatWithUTC(Date date, DateTimeFormatter formatter) {
        return KiwiDateTimeFormatters.formatWith(date, (ZoneId)ZoneOffset.UTC, formatter);
    }

    public static String formatWith(Date date, ZoneId targetZoneId, DateTimeFormatter formatter) {
        KiwiPreconditions.checkArgumentNotNull(date);
        KiwiPreconditions.checkArgumentNotNull(targetZoneId);
        KiwiPreconditions.checkArgumentNotNull(formatter);
        ZonedDateTime utcZonedDateTime = date.toInstant().atZone(ZoneOffset.UTC);
        return formatter.withZone(targetZoneId).format(utcZonedDateTime);
    }

    public static String formatWith(LocalDateTime localDateTime, ZoneId targetZoneId, DateTimeFormatter formatter) {
        return KiwiDateTimeFormatters.formatWith(localDateTime, ZoneOffset.UTC, targetZoneId, formatter);
    }

    public static String formatWith(LocalDateTime localDateTime, ZoneId localZoneId, ZoneId targetZoneId, DateTimeFormatter formatter) {
        KiwiPreconditions.checkArgumentNotNull(localDateTime);
        KiwiPreconditions.checkArgumentNotNull(localZoneId);
        KiwiPreconditions.checkArgumentNotNull(targetZoneId);
        KiwiPreconditions.checkArgumentNotNull(formatter);
        ZonedDateTime zonedDateTime = localDateTime.atZone(localZoneId);
        return formatter.withZone(targetZoneId).format(zonedDateTime);
    }

    public static String formatWith(ZonedDateTime zonedDateTime, ZoneId targetZoneId, DateTimeFormatter formatter) {
        KiwiPreconditions.checkArgumentNotNull(zonedDateTime);
        KiwiPreconditions.checkArgumentNotNull(targetZoneId);
        KiwiPreconditions.checkArgumentNotNull(formatter);
        return formatter.withZone(targetZoneId).format(zonedDateTime);
    }

    public static String formatWith(TemporalAccessor temporalAccessor, DateTimeFormatter formatter) {
        KiwiPreconditions.checkArgumentNotNull(temporalAccessor);
        KiwiPreconditions.checkArgumentNotNull(formatter);
        return formatter.format(temporalAccessor);
    }

    @Generated
    private KiwiDateTimeFormatters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

