/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class KiwiLists {
    public static <T> boolean isNullOrEmpty(List<T> items) {
        return items == null || items.isEmpty();
    }

    public static <T> boolean isNotNullOrEmpty(List<T> items) {
        return !KiwiLists.isNullOrEmpty(items);
    }

    public static <T> boolean hasOneElement(List<T> items) {
        return Objects.nonNull(items) && items.size() == 1;
    }

    public static <T> List<T> sorted(List<T> items) {
        KiwiLists.checkNonNullInputList(items);
        return items.stream().sorted().collect(Collectors.toList());
    }

    public static <T> List<T> sorted(List<T> items, Comparator<T> comparator) {
        KiwiLists.checkNonNullInputList(items);
        Preconditions.checkNotNull(comparator, (Object)"Comparator cannot be null");
        return items.stream().sorted(comparator).collect(Collectors.toList());
    }

    public static <T> T first(List<T> items) {
        return KiwiLists.nth(items, 1);
    }

    public static <T> Optional<T> firstIfPresent(List<T> items) {
        return KiwiLists.isNotNullOrEmpty(items) ? Optional.of(KiwiLists.first(items)) : Optional.empty();
    }

    public static <T> T second(List<T> items) {
        return KiwiLists.nth(items, 2);
    }

    public static <T> T third(List<T> items) {
        return KiwiLists.nth(items, 3);
    }

    public static <T> T fourth(List<T> items) {
        return KiwiLists.nth(items, 4);
    }

    public static <T> T fifth(List<T> items) {
        return KiwiLists.nth(items, 5);
    }

    public static <T> T penultimate(List<T> items) {
        KiwiLists.checkMinimumSize(items, 2);
        return KiwiLists.nth(items, items.size() - 1);
    }

    public static <T> T secondToLast(List<T> items) {
        return KiwiLists.penultimate(items);
    }

    public static <T> T last(List<T> items) {
        return KiwiLists.nth(items, items.size());
    }

    public static <T> Optional<T> lastIfPresent(List<T> items) {
        return KiwiLists.isNotNullOrEmpty(items) ? Optional.of(KiwiLists.last(items)) : Optional.empty();
    }

    public static <T> T nth(List<T> items, int number) {
        KiwiLists.checkMinimumSize(items, number);
        return items.get(number - 1);
    }

    public static <T> List<T> distinct(Collection<T> collection) {
        Preconditions.checkArgument((boolean)Objects.nonNull(collection), (Object)"collection can not be null");
        return KiwiLists.distinctOrNull(collection);
    }

    public static <T> List<T> distinctOrNull(Collection<T> collection) {
        return Objects.nonNull(collection) ? collection.stream().distinct().collect(Collectors.toList()) : null;
    }

    @VisibleForTesting
    static <T> void checkMinimumSize(List<T> items, int minSize) {
        KiwiLists.checkNonNullInputList(items);
        Preconditions.checkArgument((minSize > 0 ? 1 : 0) != 0, (Object)"number must be positive");
        Preconditions.checkArgument((items.size() >= minSize ? 1 : 0) != 0, (String)"expected at least %s items (actual size: %s)", (int)minSize, (int)items.size());
    }

    public static <T> void checkNonNullInputList(List<T> items) {
        Preconditions.checkNotNull(items, (Object)"items cannot be null");
    }

    public static <T> List<T> newListStartingAtCircularOffset(List<T> input, long startOffset) {
        int size = input.size();
        return IntStream.range(0, size).mapToObj(i -> input.get((int)(startOffset + (long)i) % size)).collect(Collectors.toList());
    }

    private KiwiLists() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

