/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.concurrent.AsyncException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Async {
    private static final Logger LOG = LoggerFactory.getLogger(Async.class);
    private static Mode asyncMode = Mode.ENABLED;

    public static void setUnitTestAsyncMode(Mode mode) {
        KiwiPreconditions.checkArgumentNotNull(mode, "mode cannot be null");
        if (mode == Mode.DISABLED) {
            LOG.warn("===================================================================");
            LOG.warn("------------ DISABLING ASYNC IS FOR TEST USE ONLY -----------------");
            LOG.warn("===================================================================");
        }
        asyncMode = mode;
    }

    public static CompletableFuture<Void> doAsync(Runnable func) {
        return Async.doAsync(func, (Executor)ForkJoinPool.commonPool());
    }

    public static CompletableFuture<Void> doAsync(Runnable func, Executor executor) {
        return Async.waitIfAsyncDisabled(CompletableFuture.runAsync(func, executor));
    }

    public static <T> CompletableFuture<T> doAsync(Supplier<T> supplier) {
        return Async.doAsync(supplier, (Executor)ForkJoinPool.commonPool());
    }

    public static <T> CompletableFuture<T> doAsync(Supplier<T> supplier, Executor executor) {
        return Async.waitIfAsyncDisabled(CompletableFuture.supplyAsync(supplier, executor));
    }

    @VisibleForTesting
    static <T> CompletableFuture<T> waitIfAsyncDisabled(CompletableFuture<T> future) {
        if (asyncMode == Mode.DISABLED) {
            LOG.trace("asyncMode = DISABLED; wait for the future!");
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Encountered error waiting for future: ", (Throwable)e);
            }
        }
        future.whenComplete(Async::logException);
        return future;
    }

    private static <T> void logException(T result, Throwable thrown) {
        if (Objects.nonNull(thrown)) {
            LOG.error("Encountered exception in async task: {}", (Object)thrown.getMessage());
            LOG.debug("Exception details", thrown);
        }
    }

    public static <T> void waitFor(CompletableFuture<T> future, long timeout, TimeUnit unit) {
        Async.waitForAll(List.of(future), timeout, unit);
    }

    public static <T> void waitForAll(Collection<CompletableFuture<T>> futures, long timeout, TimeUnit unit) {
        try {
            CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).get(timeout, unit);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            Async.logAndThrowAsyncException(timeout, unit, ex, null);
        }
        catch (ExecutionException | TimeoutException ex) {
            Async.logAndThrowAsyncException(timeout, unit, ex, null);
        }
    }

    public static void waitForAllIgnoringType(Collection<CompletableFuture> futures, long timeout, TimeUnit unit) {
        try {
            CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).get(timeout, unit);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            Async.logAndThrowAsyncException(timeout, unit, ex, null);
        }
        catch (ExecutionException | TimeoutException ex) {
            Async.logAndThrowAsyncException(timeout, unit, ex, null);
        }
    }

    private static void logAndThrowAsyncException(long timeout, TimeUnit unit, Exception ex, CompletableFuture future) {
        String msg = KiwiStrings.f("Timeout occurred: maximum wait specified as {} {}", new Object[]{timeout, unit});
        LOG.error(msg, (Throwable)ex);
        throw new AsyncException(msg, ex, future);
    }

    public static <T> CompletableFuture<T> withMaxTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit) {
        return Async.withMaxTimeout(future, timeout, unit, ForkJoinPool.commonPool());
    }

    public static <T> CompletableFuture<T> withMaxTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit, ExecutorService executor) {
        Supplier<Object> supplier = () -> {
            try {
                return future.get(timeout, unit);
            }
            catch (Exception ex) {
                future.cancel(true);
                Async.logAndThrowAsyncException(timeout, unit, ex, future);
                return null;
            }
        };
        return CompletableFuture.supplyAsync(supplier, executor);
    }

    private Async() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Mode {
        ENABLED,
        DISABLED;

    }
}

