/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.metrics.health;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.annotations.VisibleForTesting;
import io.dropwizard.util.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimedHealthCheck
extends HealthCheck {
    public static final ExecutorService HEALTH_CHECK_EXECUTOR = Executors.newFixedThreadPool(3);
    private final HealthCheck delegate;
    private final Duration timeout;

    public TimedHealthCheck(HealthCheck delegate) {
        this(delegate, Duration.seconds((long)5L));
    }

    public TimedHealthCheck(HealthCheck delegate, Duration timeout) {
        this.delegate = delegate;
        this.timeout = timeout;
    }

    protected HealthCheck.Result check() {
        CompletableFuture<HealthCheck.Result> healthCheckFuture = this.getFuture();
        try {
            return healthCheckFuture.get(this.timeout.toSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return this.createInterruptedResult(e);
        }
        catch (ExecutionException e) {
            return this.createExecutionErrorResult(e);
        }
        catch (TimeoutException e) {
            return this.createTimeoutResult(e);
        }
    }

    @VisibleForTesting
    CompletableFuture<HealthCheck.Result> getFuture() {
        return CompletableFuture.supplyAsync(() -> ((HealthCheck)this.delegate).execute(), HEALTH_CHECK_EXECUTOR);
    }

    private HealthCheck.Result createTimeoutResult(Exception e) {
        return HealthCheck.Result.builder().unhealthy((Throwable)e).withMessage("Unable to obtain result in %d seconds", new Object[]{this.timeout.toSeconds()}).build();
    }

    private HealthCheck.Result createExecutionErrorResult(Exception e) {
        return HealthCheck.Result.builder().unhealthy((Throwable)e).build();
    }

    private HealthCheck.Result createInterruptedResult(Exception e) {
        return HealthCheck.Result.builder().unhealthy((Throwable)e).withMessage("Unable to obtain result due to process being interrupted").build();
    }
}

