/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDeserializationProblemHandler
extends DeserializationProblemHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingDeserializationProblemHandler.class);
    private final ConcurrentMap<String, String> unexpectedPaths = new ConcurrentHashMap<String, String>();
    private final BiConsumer<String, Class<?>> unknownPropertyConsumer;

    public LoggingDeserializationProblemHandler() {
        this((propertyName, aClass) -> {});
    }

    public LoggingDeserializationProblemHandler(BiConsumer<String, Class<?>> unknownPropertyConsumer) {
        this.unknownPropertyConsumer = unknownPropertyConsumer;
    }

    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
        String path = p.getParsingContext().pathAsPointer().toString().replace("/", ".");
        String className = beanOrClass.getClass().getName();
        LOG.warn("Unable to deserialize path: '{}' for class: {}", (Object)path, (Object)className);
        p.skipChildren();
        String key = className + path;
        String val = className + " -> " + path;
        this.unexpectedPaths.putIfAbsent(key, val);
        this.notifyConsumer(beanOrClass, path);
        return true;
    }

    private void notifyConsumer(Object beanOrClass, String path) {
        try {
            this.unknownPropertyConsumer.accept(path, beanOrClass.getClass());
        }
        catch (Exception e) {
            LOG.error("unknownPropertyConsumer threw exception", (Throwable)e);
        }
    }

    public void clearUnexpectedPaths() {
        this.unexpectedPaths.clear();
    }

    public Set<String> getUnexpectedPaths() {
        return Set.copyOf(this.unexpectedPaths.values());
    }

    public Set<String> getUnexpectedPropertyPaths() {
        return Set.copyOf(this.unexpectedPaths.keySet());
    }

    public long getUnknownPropertyCount() {
        return this.unexpectedPaths.size();
    }
}

