/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;

public class VaultConfiguration {
    @NotBlank
    private String ansibleVaultPath;
    @NotBlank
    private String vaultPasswordFilePath;
    @NotBlank
    private String tempDirectory;

    public VaultConfiguration() {
        this.tempDirectory = this.getJavaTempDir();
    }

    public VaultConfiguration(String ansibleVaultPath, String vaultPasswordFilePath, String tempDirectory) {
        this.ansibleVaultPath = KiwiPreconditions.requireNotBlank(ansibleVaultPath);
        this.vaultPasswordFilePath = KiwiPreconditions.requireNotBlank(vaultPasswordFilePath);
        this.tempDirectory = StringUtils.isBlank((CharSequence)tempDirectory) ? this.getJavaTempDir() : tempDirectory;
    }

    private String getJavaTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public VaultConfiguration copyOf() {
        return VaultConfiguration.builder().ansibleVaultPath(this.ansibleVaultPath).vaultPasswordFilePath(this.vaultPasswordFilePath).tempDirectory(this.tempDirectory).build();
    }

    public static VaultConfigurationBuilder builder() {
        return new VaultConfigurationBuilder();
    }

    public String getAnsibleVaultPath() {
        return this.ansibleVaultPath;
    }

    public String getVaultPasswordFilePath() {
        return this.vaultPasswordFilePath;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setAnsibleVaultPath(String ansibleVaultPath) {
        this.ansibleVaultPath = ansibleVaultPath;
    }

    public void setVaultPasswordFilePath(String vaultPasswordFilePath) {
        this.vaultPasswordFilePath = vaultPasswordFilePath;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public static class VaultConfigurationBuilder {
        private String ansibleVaultPath;
        private String vaultPasswordFilePath;
        private String tempDirectory;

        VaultConfigurationBuilder() {
        }

        public VaultConfigurationBuilder ansibleVaultPath(String ansibleVaultPath) {
            this.ansibleVaultPath = ansibleVaultPath;
            return this;
        }

        public VaultConfigurationBuilder vaultPasswordFilePath(String vaultPasswordFilePath) {
            this.vaultPasswordFilePath = vaultPasswordFilePath;
            return this;
        }

        public VaultConfigurationBuilder tempDirectory(String tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }

        public VaultConfiguration build() {
            return new VaultConfiguration(this.ansibleVaultPath, this.vaultPasswordFilePath, this.tempDirectory);
        }

        public String toString() {
            return "VaultConfiguration.VaultConfigurationBuilder(ansibleVaultPath=" + this.ansibleVaultPath + ", vaultPasswordFilePath=" + this.vaultPasswordFilePath + ", tempDirectory=" + this.tempDirectory + ")";
        }
    }
}

