/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import java.beans.ConstructorProperties;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.kiwiproject.ansible.vault.OsCommand;
import org.kiwiproject.ansible.vault.VaultConfiguration;
import org.kiwiproject.base.KiwiPreconditions;

public class VaultDecryptCommand
implements OsCommand {
    public static final String OUTPUT_FILE_STDOUT = "-";
    private final String ansibleVaultPath;
    private final String vaultPasswordFilePath;
    private final String encryptedFilePath;
    private final String outputFilePath;

    public static VaultDecryptCommand from(VaultConfiguration configuration, String encryptedFilePath) {
        return VaultDecryptCommand.from(configuration, encryptedFilePath, null);
    }

    public static VaultDecryptCommand toStdoutFrom(VaultConfiguration configuration, String encryptedFilePath) {
        return VaultDecryptCommand.from(configuration, encryptedFilePath, OUTPUT_FILE_STDOUT);
    }

    public static VaultDecryptCommand from(VaultConfiguration configuration, String encryptedFilePath, @Nullable String outputFilePath) {
        KiwiPreconditions.checkArgumentNotNull(configuration, "configuration cannot be null");
        KiwiPreconditions.checkArgumentNotBlank(encryptedFilePath, "encryptedFilePath cannot be blank");
        return VaultDecryptCommand.builder().ansibleVaultPath(configuration.getAnsibleVaultPath()).vaultPasswordFilePath(configuration.getVaultPasswordFilePath()).encryptedFilePath(encryptedFilePath).outputFilePath(outputFilePath).build();
    }

    @Override
    public List<String> getCommandParts() {
        if (Objects.nonNull(this.outputFilePath)) {
            return this.getCommandPartsWithOutputFile();
        }
        return this.getCommandPartsWithNoOutputFile();
    }

    private List<String> getCommandPartsWithOutputFile() {
        return List.of(this.ansibleVaultPath, "decrypt", "--vault-password-file", this.vaultPasswordFilePath, "--output", this.outputFilePath, Paths.get(this.encryptedFilePath, new String[0]).toString());
    }

    private List<String> getCommandPartsWithNoOutputFile() {
        return List.of(this.ansibleVaultPath, "decrypt", "--vault-password-file", this.vaultPasswordFilePath, Paths.get(this.encryptedFilePath, new String[0]).toString());
    }

    @ConstructorProperties(value={"ansibleVaultPath", "vaultPasswordFilePath", "encryptedFilePath", "outputFilePath"})
    VaultDecryptCommand(String ansibleVaultPath, String vaultPasswordFilePath, String encryptedFilePath, String outputFilePath) {
        this.ansibleVaultPath = ansibleVaultPath;
        this.vaultPasswordFilePath = vaultPasswordFilePath;
        this.encryptedFilePath = encryptedFilePath;
        this.outputFilePath = outputFilePath;
    }

    public static VaultDecryptCommandBuilder builder() {
        return new VaultDecryptCommandBuilder();
    }

    public static class VaultDecryptCommandBuilder {
        private String ansibleVaultPath;
        private String vaultPasswordFilePath;
        private String encryptedFilePath;
        private String outputFilePath;

        VaultDecryptCommandBuilder() {
        }

        public VaultDecryptCommandBuilder ansibleVaultPath(String ansibleVaultPath) {
            this.ansibleVaultPath = ansibleVaultPath;
            return this;
        }

        public VaultDecryptCommandBuilder vaultPasswordFilePath(String vaultPasswordFilePath) {
            this.vaultPasswordFilePath = vaultPasswordFilePath;
            return this;
        }

        public VaultDecryptCommandBuilder encryptedFilePath(String encryptedFilePath) {
            this.encryptedFilePath = encryptedFilePath;
            return this;
        }

        public VaultDecryptCommandBuilder outputFilePath(String outputFilePath) {
            this.outputFilePath = outputFilePath;
            return this;
        }

        public VaultDecryptCommand build() {
            return new VaultDecryptCommand(this.ansibleVaultPath, this.vaultPasswordFilePath, this.encryptedFilePath, this.outputFilePath);
        }

        public String toString() {
            return "VaultDecryptCommand.VaultDecryptCommandBuilder(ansibleVaultPath=" + this.ansibleVaultPath + ", vaultPasswordFilePath=" + this.vaultPasswordFilePath + ", encryptedFilePath=" + this.encryptedFilePath + ", outputFilePath=" + this.outputFilePath + ")";
        }
    }
}

