/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.kiwiproject.ansible.vault.OsCommand;
import org.kiwiproject.ansible.vault.VaultConfiguration;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;

public class VaultEncryptStringCommand
implements OsCommand {
    private final String ansibleVaultPath;
    private final String vaultIdLabel;
    private final String vaultPasswordFilePath;
    private final String variableName;
    private final String plainText;

    public static VaultEncryptStringCommand from(VaultConfiguration configuration, String plainText, String variableName) {
        return VaultEncryptStringCommand.from(configuration, null, plainText, variableName);
    }

    public static VaultEncryptStringCommand from(VaultConfiguration configuration, @Nullable String vaultIdLabel, String plainText, String variableName) {
        KiwiPreconditions.checkArgumentNotNull(configuration, "configuration cannot be null");
        KiwiPreconditions.checkArgumentNotBlank(plainText, "plainText cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(variableName, "variableName cannot be blank");
        return VaultEncryptStringCommand.builder().ansibleVaultPath(configuration.getAnsibleVaultPath()).vaultIdLabel(vaultIdLabel).vaultPasswordFilePath(configuration.getVaultPasswordFilePath()).variableName(variableName).plainText(plainText).build();
    }

    @Override
    public List<String> getCommandParts() {
        if (Objects.isNull(this.vaultIdLabel)) {
            return List.of(this.ansibleVaultPath, "encrypt_string", "--vault-password-file", this.vaultPasswordFilePath, "--name", this.variableName, this.plainText);
        }
        return List.of(this.ansibleVaultPath, "encrypt_string", "--vault-id", this.vaultIdArgument(), "--name", this.variableName, this.plainText);
    }

    private String vaultIdArgument() {
        return KiwiStrings.f("{}@{}", this.vaultIdLabel, this.vaultPasswordFilePath);
    }

    @ConstructorProperties(value={"ansibleVaultPath", "vaultIdLabel", "vaultPasswordFilePath", "variableName", "plainText"})
    VaultEncryptStringCommand(String ansibleVaultPath, String vaultIdLabel, String vaultPasswordFilePath, String variableName, String plainText) {
        this.ansibleVaultPath = ansibleVaultPath;
        this.vaultIdLabel = vaultIdLabel;
        this.vaultPasswordFilePath = vaultPasswordFilePath;
        this.variableName = variableName;
        this.plainText = plainText;
    }

    public static VaultEncryptStringCommandBuilder builder() {
        return new VaultEncryptStringCommandBuilder();
    }

    public static class VaultEncryptStringCommandBuilder {
        private String ansibleVaultPath;
        private String vaultIdLabel;
        private String vaultPasswordFilePath;
        private String variableName;
        private String plainText;

        VaultEncryptStringCommandBuilder() {
        }

        public VaultEncryptStringCommandBuilder ansibleVaultPath(String ansibleVaultPath) {
            this.ansibleVaultPath = ansibleVaultPath;
            return this;
        }

        public VaultEncryptStringCommandBuilder vaultIdLabel(String vaultIdLabel) {
            this.vaultIdLabel = vaultIdLabel;
            return this;
        }

        public VaultEncryptStringCommandBuilder vaultPasswordFilePath(String vaultPasswordFilePath) {
            this.vaultPasswordFilePath = vaultPasswordFilePath;
            return this;
        }

        public VaultEncryptStringCommandBuilder variableName(String variableName) {
            this.variableName = variableName;
            return this;
        }

        public VaultEncryptStringCommandBuilder plainText(String plainText) {
            this.plainText = plainText;
            return this;
        }

        public VaultEncryptStringCommand build() {
            return new VaultEncryptStringCommand(this.ansibleVaultPath, this.vaultIdLabel, this.vaultPasswordFilePath, this.variableName, this.plainText);
        }

        public String toString() {
            return "VaultEncryptStringCommand.VaultEncryptStringCommandBuilder(ansibleVaultPath=" + this.ansibleVaultPath + ", vaultIdLabel=" + this.vaultIdLabel + ", vaultPasswordFilePath=" + this.vaultPasswordFilePath + ", variableName=" + this.variableName + ", plainText=" + this.plainText + ")";
        }
    }
}

