/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiStrings;

public final class KiwiPreconditions {
    public static <T extends Throwable> void checkArgument(boolean expression, Class<T> exceptionType) {
        if (!expression) {
            throw (Throwable)exceptionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    public static <T extends Throwable> void checkArgument(boolean expression, Class<T> exceptionType, String errorMessage) {
        if (!expression) {
            Constructor<T> constructor = exceptionType.getConstructor(String.class);
            throw (Throwable)constructor.newInstance(errorMessage);
        }
    }

    public static <T extends Throwable> void checkArgument(boolean expression, Class<T> exceptionType, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            Constructor<T> constructor = exceptionType.getConstructor(String.class);
            throw (Throwable)constructor.newInstance(KiwiStrings.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static String requireNotBlank(String value) {
        KiwiPreconditions.checkArgumentNotBlank(value);
        return value;
    }

    public static String requireNotBlank(String value, String errorMessage) {
        KiwiPreconditions.checkArgumentNotBlank(value, errorMessage);
        return value;
    }

    public static String requireNotBlank(String value, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkArgumentNotBlank(value, errorMessageTemplate, errorMessageArgs);
        return value;
    }

    public static <T> T requireNotNull(T reference) {
        KiwiPreconditions.checkArgumentNotNull(reference);
        return reference;
    }

    public static <T> T requireNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkArgumentNotNull(reference, errorMessageTemplate, errorMessageArgs);
        return reference;
    }

    public static <T> void checkArgumentNotNull(T reference) {
        Preconditions.checkArgument((boolean)Objects.nonNull(reference));
    }

    public static <T> void checkArgumentNotNull(T reference, String errorMessage) {
        Preconditions.checkArgument((boolean)Objects.nonNull(reference), (Object)errorMessage);
    }

    public static <T> void checkArgumentNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Objects.isNull(reference)) {
            throw KiwiPreconditions.newIllegalArgumentException(errorMessageTemplate, errorMessageArgs);
        }
    }

    private static IllegalArgumentException newIllegalArgumentException(String errorMessageTemplate, Object ... errorMessageArgs) {
        String errorMessage = KiwiStrings.format(errorMessageTemplate, errorMessageArgs);
        return new IllegalArgumentException(errorMessage);
    }

    public static void checkArgumentNotBlank(String string) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)string));
    }

    public static void checkArgumentNotBlank(String string, String errorMessage) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)string), (Object)errorMessage);
    }

    public static void checkArgumentNotBlank(String string, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw KiwiPreconditions.newIllegalArgumentException(errorMessageTemplate, errorMessageArgs);
        }
    }

    @SafeVarargs
    public static <T> void checkEvenItemCount(T ... items) {
        Objects.requireNonNull(items);
        KiwiPreconditions.checkEvenItemCount(() -> items.length);
    }

    public static <T> void checkEvenItemCount(Collection<T> items) {
        Objects.requireNonNull(items);
        KiwiPreconditions.checkEvenItemCount(items::size);
    }

    public static void checkEvenItemCount(IntSupplier countSupplier) {
        Objects.requireNonNull(countSupplier);
        int count = countSupplier.getAsInt();
        Preconditions.checkArgument((count % 2 == 0 ? 1 : 0) != 0, (String)"must be an even number of items (received %s)", (int)count);
    }

    public static <T> T requireNotNullElse(T obj, T defaultObj) {
        KiwiPreconditions.checkArgumentNotNull(defaultObj);
        return Objects.isNull(obj) ? defaultObj : obj;
    }

    public static <T> T requireNotNullElseGet(T obj, Supplier<? extends T> supplier) {
        KiwiPreconditions.checkArgumentNotNull(supplier);
        T value = KiwiPreconditions.requireNotNull(supplier.get(), "supplier must return a non-null object", new Object[0]);
        return Objects.isNull(obj) ? value : obj;
    }

    private KiwiPreconditions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

