/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiIO {
    private static final Logger LOG = LoggerFactory.getLogger(KiwiIO.class);

    public static void closeQuietly(Closeable closeable) {
        try {
            if (Objects.nonNull(closeable)) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            KiwiIO.logCloseException(closeable.getClass(), ioe);
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (Objects.isNull(closeables)) {
            return;
        }
        for (Closeable closeable : closeables) {
            KiwiIO.closeQuietly(closeable);
        }
    }

    public static void closeQuietly(XMLStreamReader xmlStreamReader) {
        if (Objects.nonNull(xmlStreamReader)) {
            try {
                xmlStreamReader.close();
            }
            catch (Exception e) {
                KiwiIO.logCloseException(XMLStreamReader.class, e);
            }
        }
    }

    public static void closeQuietly(XMLStreamWriter xmlStreamWriter) {
        if (Objects.nonNull(xmlStreamWriter)) {
            try {
                xmlStreamWriter.close();
            }
            catch (Exception e) {
                KiwiIO.logCloseException(XMLStreamWriter.class, e);
            }
        }
    }

    private static void logCloseException(Class<?> typeOfObject, Exception ex) {
        String typeSimpleName = typeOfObject.getSimpleName();
        LOG.warn("Unexpected error while attempting to close {} quietly (use DEBUG-level for stack trace): {}", (Object)typeSimpleName, (Object)ex.getMessage());
        LOG.debug("Error closing {} instance", (Object)typeSimpleName, (Object)ex);
    }

    public static ByteArrayInputStream newByteArrayInputStreamOfLines(String ... lines) {
        if (lines.length == 0) {
            return KiwiIO.emptyByteArrayInputStream();
        }
        String joined = Arrays.stream(lines).collect(Collectors.joining(System.lineSeparator()));
        byte[] buffer = joined.getBytes(StandardCharsets.UTF_8);
        return new ByteArrayInputStream(buffer);
    }

    public static ByteArrayInputStream emptyByteArrayInputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public static List<String> readLinesFromErrorStreamOf(Process process) {
        return KiwiIO.readLinesFrom(process.getErrorStream(), StandardCharsets.UTF_8);
    }

    public static List<String> readLinesFromErrorStreamOf(Process process, Charset charset) {
        return KiwiIO.readLinesFrom(process.getErrorStream(), charset);
    }

    public static List<String> readLinesFromInputStreamOf(Process process) {
        return KiwiIO.readLinesFrom(process.getInputStream(), StandardCharsets.UTF_8);
    }

    public static List<String> readLinesFromInputStreamOf(Process process, Charset charset) {
        return KiwiIO.readLinesFrom(process.getInputStream(), charset);
    }

    public static List<String> readLinesFrom(InputStream stream, Charset charset) {
        return KiwiIO.streamLinesFrom(stream, charset).collect(Collectors.toList());
    }

    public static Stream<String> streamLinesFromErrorStreamOf(Process process) {
        return KiwiIO.streamLinesFrom(process.getErrorStream(), StandardCharsets.UTF_8);
    }

    public static Stream<String> streamLinesFromErrorStreamOf(Process process, Charset charset) {
        return KiwiIO.streamLinesFrom(process.getErrorStream(), charset);
    }

    public static Stream<String> streamLinesFromInputStreamOf(Process process) {
        return KiwiIO.streamLinesFrom(process.getInputStream(), StandardCharsets.UTF_8);
    }

    public static Stream<String> streamLinesFromInputStreamOf(Process process, Charset charset) {
        return KiwiIO.streamLinesFrom(process.getInputStream(), charset);
    }

    public static Stream<String> streamLinesFrom(InputStream stream, Charset charset) {
        return new BufferedReader(new InputStreamReader(stream, charset)).lines();
    }

    private KiwiIO() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

