/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.format.DataFormatDetector;
import com.fasterxml.jackson.core.format.DataFormatMatcher;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.kiwiproject.jackson.JacksonDataFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiJacksonDataFormats {
    private static final Logger LOG = LoggerFactory.getLogger(KiwiJacksonDataFormats.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final DataFormatDetector DEFAULT_FORMAT_DETECTOR = new DataFormatDetector(new JsonFactory[]{new JsonFactory(), new XmlFactory(), new YAMLFactory()});

    public static boolean isJson(String text) {
        return KiwiJacksonDataFormats.isJson(text, DEFAULT_CHARSET);
    }

    public static boolean isJsonUtf8(String text) {
        return KiwiJacksonDataFormats.isJson(text, StandardCharsets.UTF_8);
    }

    public static boolean isJson(String text, Charset charset) {
        return KiwiJacksonDataFormats.isFormat(JacksonDataFormat.JSON, text, charset);
    }

    public static boolean isXml(String text) {
        return KiwiJacksonDataFormats.isXml(text, DEFAULT_CHARSET);
    }

    public static boolean isXmlUtf8(String text) {
        return KiwiJacksonDataFormats.isXml(text, StandardCharsets.UTF_8);
    }

    public static boolean isXml(String text, Charset charset) {
        return KiwiJacksonDataFormats.isFormat(JacksonDataFormat.XML, text, charset);
    }

    public static boolean isYaml(String text) {
        return KiwiJacksonDataFormats.isYaml(text, DEFAULT_CHARSET);
    }

    public static boolean isYamlUtf8(String text) {
        return KiwiJacksonDataFormats.isYaml(text, StandardCharsets.UTF_8);
    }

    public static boolean isYaml(String text, Charset charset) {
        return KiwiJacksonDataFormats.isFormat(JacksonDataFormat.YAML, text, charset);
    }

    public static boolean isFormat(JacksonDataFormat matchFormat, String text, Charset charset) {
        return KiwiJacksonDataFormats.detectFormat(text, charset).filter(dataFormat -> dataFormat == matchFormat).isPresent();
    }

    public static Optional<JacksonDataFormat> detectFormat(String text) {
        return KiwiJacksonDataFormats.detectFormat(text, DEFAULT_CHARSET);
    }

    public static Optional<JacksonDataFormat> detectFormatUtf8(String text) {
        return KiwiJacksonDataFormats.detectFormat(text, StandardCharsets.UTF_8);
    }

    public static Optional<JacksonDataFormat> detectFormat(String text, Charset charset) {
        Optional<String> optionalFormatName = KiwiJacksonDataFormats.detectFormat(text, charset, DEFAULT_FORMAT_DETECTOR);
        return optionalFormatName.map(JacksonDataFormat::from).or(Optional::empty);
    }

    public static Optional<String> detectFormat(String text, Charset charset, DataFormatDetector detector) {
        try {
            byte[] bytes = text.getBytes(charset);
            DataFormatMatcher formatMatcher = detector.findFormat(bytes);
            if (formatMatcher.hasMatch()) {
                return Optional.of(formatMatcher.getMatchedFormatName());
            }
        }
        catch (IOException e) {
            LOG.debug("Error finding data format", (Throwable)e);
        }
        return Optional.empty();
    }

    private KiwiJacksonDataFormats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

