/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jars {
    private static final Logger LOG = LoggerFactory.getLogger(Jars.class);

    public static List<String> getPathComponents(Class<?> classInJar) {
        KiwiPreconditions.checkArgumentNotNull(classInJar, "classInJar cannot be null");
        try {
            CodeSource codeSource = classInJar.getProtectionDomain().getCodeSource();
            Preconditions.checkNotNull((Object)codeSource, (String)"Code source for %s is null", classInJar);
            String encodedJarPath = codeSource.getLocation().getPath();
            String decodedJarPath = URLDecoder.decode(encodedJarPath, StandardCharsets.UTF_8);
            return Lists.newArrayList((Object[])decodedJarPath.trim().split(File.separator));
        }
        catch (Exception e) {
            return Jars.logExceptionAndReturnEmptyList(e, classInJar);
        }
    }

    @VisibleForTesting
    static List<String> logExceptionAndReturnEmptyList(Exception ex, Class<?> classInJar) {
        LOG.error("Error getting Jar path components for {}! (turn on DEBUG logging to see stack traces)", classInJar);
        LOG.debug("Exception related to {}:", classInJar, (Object)ex);
        return Collections.emptyList();
    }

    public static Optional<String> getPath(Class<?> classInJar) {
        List<String> pathComponents = Jars.getPathComponents(classInJar);
        return Jars.joined(pathComponents);
    }

    public static Optional<String> getDirectoryPath(Class<?> classInJar) {
        List<String> pathComponents = Jars.getPathComponents(classInJar);
        Preconditions.checkState((boolean)KiwiLists.isNotNullOrEmpty(pathComponents), (Object)"there must be at least one path component!");
        return Jars.joined(pathComponents.subList(0, pathComponents.size() - 1));
    }

    @VisibleForTesting
    static Optional<String> joined(List<String> parts) {
        if (KiwiLists.isNullOrEmpty(parts)) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)File.separator, parts));
    }

    private Jars() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

