/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jdbi2.sqlobject;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.kiwiproject.jdbc.postgres.KiwiPostgres;
import org.postgresql.util.PGobject;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;
import org.skife.jdbi.v2.sqlobject.BindingAnnotation;

@BindingAnnotation(value=JsonBinderFactory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindJSONB {
    public String value();

    public static class JsonBinderFactory
    implements BinderFactory<BindJSONB> {
        public Binder build(BindJSONB annotation) {
            return (sqlStatement, bind, json) -> {
                PGobject pgObject = KiwiPostgres.newJSONBObject(json);
                sqlStatement.bind(bind.value(), (Object)pgObject);
            };
        }
    }
}

