/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.net;

import com.google.common.base.Splitter;
import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.net.UncheckedMalformedURLException;

public final class KiwiUrls {
    public static final int UNKNOWN_PORT = -1;
    public static final String FTP_PROTOCOL = "ftp";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String SFTP_PROTOCOL = "sftp";
    private static final Pattern URL_PATTERN = Pattern.compile("((?<scheme>[a-z]+)://)?(?<canonical>(?<subdomain>[a-z0-9-]+)(\\.(?<domain>[a-z0-9.-]+))?)(:(?<port>[0-9]+))?(?<path>/.*)?", 2);
    public static final String SCHEME_GROUP = "scheme";
    public static final String CANONICAL_GROUP = "canonical";
    public static final String SUB_DOMAIN_GROUP = "subdomain";
    public static final String DOMAIN_GROUP = "domain";
    public static final String PORT_GROUP = "port";
    public static final String PATH_GROUP = "path";
    public static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();

    public static String createUrl(String protocol, String hostname, int port) {
        return KiwiUrls.createUrlObject(protocol, hostname, port).toString();
    }

    public static URL createUrlObject(String protocol, String hostname, int port) {
        return KiwiUrls.createUrlObject(protocol, hostname, port, "");
    }

    public static String createUrl(String protocol, String hostname, int port, String path) {
        return KiwiUrls.createUrlObject(protocol, hostname, port, path).toString();
    }

    public static URL createUrlObject(String protocol, String hostname, int port, String path) {
        try {
            String pathWithLeadingSlash = StringUtils.isBlank((CharSequence)path) ? "" : KiwiUrls.prependLeadingSlash(path);
            return new URL(protocol, hostname, port, pathWithLeadingSlash);
        }
        catch (MalformedURLException e) {
            String message = KiwiStrings.f("Error constructing URL from protocol [%s], hostname [%s], port [%s], path [%s]", protocol, hostname, port, path);
            throw new UncheckedMalformedURLException(message, e);
        }
    }

    public static URL createUrlObject(String urlSpec) {
        try {
            return new URL(urlSpec);
        }
        catch (MalformedURLException e) {
            throw new UncheckedMalformedURLException(e);
        }
    }

    public static String createUrl(String schemeHostPort, String ... pathComponents) {
        return KiwiUrls.createUrlObject(schemeHostPort, pathComponents).toString();
    }

    public static URL createUrlObject(String schemeHostPort, String ... pathComponents) {
        URI rawBaseUri = URI.create(schemeHostPort);
        if (pathComponents.length == 0) {
            return KiwiUrls.toURL(rawBaseUri);
        }
        String baseUri = KiwiUrls.stripTrailingSlash(rawBaseUri.toString());
        String path = Paths.get("/", pathComponents).toString();
        String fullUrlString = baseUri + path;
        return KiwiUrls.toURL(URI.create(fullUrlString));
    }

    public static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            String message = "Error creating URL from: " + uri.toString();
            throw new UncheckedMalformedURLException(message, e);
        }
    }

    public static String prependLeadingSlash(String path) {
        String trimmedPath = path.trim();
        if (trimmedPath.charAt(0) == '/') {
            return trimmedPath;
        }
        return "/" + trimmedPath;
    }

    public static String createHttpUrl(String hostname, int port) {
        return KiwiUrls.createHttpUrlObject(hostname, port).toString();
    }

    public static URL createHttpUrlObject(String hostname, int port) {
        return KiwiUrls.createUrlObject(HTTP_PROTOCOL, hostname, port);
    }

    public static String createHttpUrl(String hostname, int port, String path) {
        return KiwiUrls.createHttpUrlObject(hostname, port, path).toString();
    }

    public static URL createHttpUrlObject(String hostname, int port, String path) {
        return KiwiUrls.createUrlObject(HTTP_PROTOCOL, hostname, port, path);
    }

    public static String createHttpsUrl(String hostname, int port) {
        return KiwiUrls.createHttpsUrlObject(hostname, port).toString();
    }

    public static URL createHttpsUrlObject(String hostname, int port) {
        return KiwiUrls.createUrlObject(HTTPS_PROTOCOL, hostname, port);
    }

    public static String createHttpsUrl(String hostname, int port, String path) {
        return KiwiUrls.createHttpsUrlObject(hostname, port, path).toString();
    }

    public static URL createHttpsUrlObject(String hostname, int port, String path) {
        return KiwiUrls.createUrlObject(HTTPS_PROTOCOL, hostname, port, path);
    }

    public static Components extractAllFrom(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            String portString = matcher.group(PORT_GROUP);
            String scheme = matcher.group(SCHEME_GROUP);
            int port = StringUtils.isBlank((CharSequence)portString) ? KiwiUrls.defaultPortForScheme(scheme) : Integer.parseInt(portString);
            Components components = Components.builder().scheme(scheme).subDomainName(matcher.group(SUB_DOMAIN_GROUP)).domainName(matcher.group(DOMAIN_GROUP)).canonicalName(matcher.group(CANONICAL_GROUP)).path(matcher.group(PATH_GROUP)).build();
            if (port > 0) {
                components = components.toBuilder().port(port).build();
            }
            return components;
        }
        return Components.builder().build();
    }

    public static String stripTrailingSlash(String url) {
        String trimmedUrl = url.trim();
        if (trimmedUrl.endsWith("/")) {
            return trimmedUrl.substring(0, trimmedUrl.length() - 1);
        }
        return trimmedUrl;
    }

    public static List<String> stripTrailingSlashes(List<String> urls) {
        return urls.stream().map(KiwiUrls::stripTrailingSlash).collect(Collectors.toList());
    }

    public static Optional<String> extractCanonicalNameFrom(String url) {
        return KiwiUrls.findGroupInUrl(url, CANONICAL_GROUP);
    }

    public static Optional<String> extractDomainNameFrom(String url) {
        return KiwiUrls.findGroupInUrl(url, DOMAIN_GROUP);
    }

    public static Optional<String> extractPathFrom(String url) {
        Optional<String> result = KiwiUrls.findGroupInUrl(url, PATH_GROUP);
        if (result.isPresent()) {
            String value = result.get();
            if ("/".equals(value)) {
                return Optional.empty();
            }
            return result;
        }
        return Optional.empty();
    }

    public static OptionalInt extractPortFrom(String url) {
        Optional<String> optionalPort = KiwiUrls.findGroupInUrl(url, PORT_GROUP);
        Integer port = optionalPort.map(Integer::parseInt).orElseGet(() -> KiwiUrls.extractSchemeFrom(url).map(KiwiUrls::defaultPortForScheme).orElse(-1));
        if (port > 0) {
            return OptionalInt.of(port);
        }
        return OptionalInt.empty();
    }

    public static Optional<String> extractSchemeFrom(String url) {
        return KiwiUrls.findGroupInUrl(url, SCHEME_GROUP);
    }

    public static Optional<String> extractSubDomainNameFrom(String url) {
        return KiwiUrls.findGroupInUrl(url, SUB_DOMAIN_GROUP);
    }

    public static String replaceDomainsIn(String commaDelimitedUrls, String replacementDomain) {
        List urls = COMMA_SPLITTER.splitToList((CharSequence)commaDelimitedUrls);
        String originalDomain = KiwiUrls.domainOrNull((String)KiwiLists.first(urls));
        if (Objects.isNull(originalDomain)) {
            return commaDelimitedUrls;
        }
        return urls.stream().map(KiwiUrls::createUrlObject).map(url -> KiwiUrls.replaceDomain(url, originalDomain, replacementDomain)).collect(Collectors.joining(","));
    }

    private static String domainOrNull(String url) {
        String oldDomain;
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches() && Objects.nonNull(oldDomain = matcher.group(DOMAIN_GROUP))) {
            return oldDomain;
        }
        return null;
    }

    private static String replaceDomain(URL url, String expectedDomain, String replacementDomain) {
        String host = url.getHost();
        int index = host.indexOf(46);
        if (index < 0) {
            return url.toString();
        }
        String actualDomain = host.substring(index + 1);
        if (!actualDomain.equals(expectedDomain)) {
            return url.toString();
        }
        String hostMinusDomain = host.substring(0, index);
        String newHost = hostMinusDomain + "." + replacementDomain;
        String port = url.getPort() == -1 ? "" : ":" + url.getPort();
        String path = StringUtils.isBlank((CharSequence)url.getPath()) ? "" : url.getPath();
        return url.getProtocol() + "://" + newHost + port + path;
    }

    private static int defaultPortForScheme(String scheme) {
        switch (scheme) {
            case "https": {
                return 443;
            }
            case "http": {
                return 80;
            }
            case "sftp": {
                return 22;
            }
            case "ftp": {
                return 21;
            }
        }
        return -1;
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return new HashMap<String, String>();
        }
        return Arrays.stream(queryString.split("&")).map(keyValue -> keyValue.split("=")).collect(Collectors.toMap(splat -> splat[0], splat -> splat[1]));
    }

    public static String toQueryString(Map<String, String> parameters) {
        if (KiwiMaps.isNullOrEmpty(parameters)) {
            return "";
        }
        return parameters.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
    }

    private static Optional<String> findGroupInUrl(String url, String matchGroup) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            return Optional.ofNullable(matcher.group(matchGroup));
        }
        return Optional.empty();
    }

    private KiwiUrls() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Components {
        private final String scheme;
        private final String subDomainName;
        private final String domainName;
        private final String canonicalName;
        private final Integer port;
        private final String path;

        public Optional<Integer> getPort() {
            return Optional.ofNullable(this.port);
        }

        public Optional<String> getPath() {
            if ("/".equals(this.path)) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.path);
        }

        @ConstructorProperties(value={"scheme", "subDomainName", "domainName", "canonicalName", "port", "path"})
        Components(String scheme, String subDomainName, String domainName, String canonicalName, Integer port, String path) {
            this.scheme = scheme;
            this.subDomainName = subDomainName;
            this.domainName = domainName;
            this.canonicalName = canonicalName;
            this.port = port;
            this.path = path;
        }

        public static ComponentsBuilder builder() {
            return new ComponentsBuilder();
        }

        public ComponentsBuilder toBuilder() {
            return new ComponentsBuilder().scheme(this.scheme).subDomainName(this.subDomainName).domainName(this.domainName).canonicalName(this.canonicalName).port(this.port).path(this.path);
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getSubDomainName() {
            return this.subDomainName;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public static class ComponentsBuilder {
            private String scheme;
            private String subDomainName;
            private String domainName;
            private String canonicalName;
            private Integer port;
            private String path;

            ComponentsBuilder() {
            }

            public ComponentsBuilder scheme(String scheme) {
                this.scheme = scheme;
                return this;
            }

            public ComponentsBuilder subDomainName(String subDomainName) {
                this.subDomainName = subDomainName;
                return this;
            }

            public ComponentsBuilder domainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public ComponentsBuilder canonicalName(String canonicalName) {
                this.canonicalName = canonicalName;
                return this;
            }

            public ComponentsBuilder port(Integer port) {
                this.port = port;
                return this;
            }

            public ComponentsBuilder path(String path) {
                this.path = path;
                return this;
            }

            public Components build() {
                return new Components(this.scheme, this.subDomainName, this.domainName, this.canonicalName, this.port, this.path);
            }

            public String toString() {
                return "KiwiUrls.Components.ComponentsBuilder(scheme=" + this.scheme + ", subDomainName=" + this.subDomainName + ", domainName=" + this.domainName + ", canonicalName=" + this.canonicalName + ", port=" + this.port + ", path=" + this.path + ")";
            }
        }
    }
}

