/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import com.google.common.base.Predicate;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.base.KiwiThrowables;
import org.kiwiproject.base.UUIDs;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.retry.KiwiRetryerException;
import org.kiwiproject.retry.KiwiRetryerPredicates;
import org.kiwiproject.retry.RetryLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class KiwiRetryer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(KiwiRetryer.class);
    private static final long DEFAULT_INITIAL_SLEEP_TIME_MILLISECONDS = 100L;
    private static final long DEFAULT_RETRY_INCREMENT_TIME_MILLISECONDS = 200L;
    private static final int DEFAULT_MAXIMUM_ATTEMPTS = 5;
    private final String retryerId;
    private final long initialSleepTimeAmount;
    private final TimeUnit initialSleepTimeUnit;
    private final long retryIncrementTimeAmount;
    private final TimeUnit retryIncrementTimeUnit;
    private final int maxAttempts;
    private final Level processingLogLevel;
    private final Level exceptionLogLevel;
    private final boolean retryOnAllExceptions;
    private final boolean retryOnAllRuntimeExceptions;
    private final List<Predicate<Throwable>> exceptionPredicates;
    private final List<Predicate<T>> resultPredicates;
    private final StopStrategy stopStrategy;
    private final WaitStrategy waitStrategy;

    public static <T> KiwiRetryer<T> newRetryerWithDefaults() {
        return KiwiRetryer.builder().build();
    }

    public static <T> KiwiRetryer<T> newRetryerWithDefaultExceptions(String retryerId) {
        return KiwiRetryer.builder().retryerId(retryerId).exceptionPredicate(KiwiRetryerPredicates.CONNECTION_ERROR).exceptionPredicate(KiwiRetryerPredicates.NO_ROUTE_TO_HOST).exceptionPredicate(KiwiRetryerPredicates.SOCKET_TIMEOUT).exceptionPredicate(KiwiRetryerPredicates.UNKNOWN_HOST).build();
    }

    public static <T> KiwiRetryer<T> newRetryerRetryingAllExceptions(String retryerId) {
        return KiwiRetryer.builder().retryerId(retryerId).retryOnAllExceptions(true).build();
    }

    public static <T> KiwiRetryer<T> newRetryerRetryingAllRuntimeExceptions(String retryerId) {
        return KiwiRetryer.builder().retryerId(retryerId).retryOnAllRuntimeExceptions(true).build();
    }

    public T call(Callable<T> callable) {
        return this.call(this.retryerId, callable);
    }

    public T call(String retryerId, Callable<T> callable) {
        try {
            Retryer<T> retryer = this.buildRetryer(retryerId);
            LOG.debug("Calling retryer with id: {}", (Object)retryerId);
            return (T)retryer.call(callable);
        }
        catch (RetryException e) {
            String message = KiwiStrings.f("KiwiRetryer {} failed all {} attempts. Error: {}", retryerId, e.getNumberOfFailedAttempts(), e.getMessage());
            throw new KiwiRetryerException(message, e);
        }
        catch (ExecutionException e) {
            String message = KiwiStrings.f("KiwiRetryer {} failed making call. Wrapped exception: {}", retryerId, e.getCause());
            throw new KiwiRetryerException(message, e);
        }
    }

    private Retryer<T> buildRetryer(String retryerId) {
        WaitStrategy theWaitStrategy = this.determineWaitStrategy();
        StopStrategy theStopStrategy = this.determineStopStrategy();
        LoggingRetryListener theLogListener = new LoggingRetryListener(retryerId, this.processingLogLevel, this.exceptionLogLevel);
        RetryerBuilder retryerBuilder = RetryerBuilder.newBuilder().withWaitStrategy(theWaitStrategy).withStopStrategy(theStopStrategy).withRetryListener((RetryListener)theLogListener);
        if (this.retryOnAllExceptions) {
            this.logIfRetryOnRuntimeExceptionsIsSet();
            this.logIfExceptionPredicatesIsNotEmpty();
            retryerBuilder.retryIfException();
        } else if (this.retryOnAllRuntimeExceptions) {
            this.logIfExceptionPredicatesIsNotEmpty();
            retryerBuilder.retryIfRuntimeException();
        } else {
            this.exceptionPredicates.forEach(arg_0 -> ((RetryerBuilder)retryerBuilder).retryIfException(arg_0));
        }
        this.resultPredicates.forEach(arg_0 -> ((RetryerBuilder)retryerBuilder).retryIfResult(arg_0));
        return retryerBuilder.build();
    }

    private void logIfRetryOnRuntimeExceptionsIsSet() {
        if (this.retryOnAllRuntimeExceptions) {
            LOG.warn("Both retryOnAllExceptions and retryOnAllRuntimeExceptions are set; retryOnAllExceptions takes precedence");
        }
    }

    private void logIfExceptionPredicatesIsNotEmpty() {
        if (KiwiLists.isNotNullOrEmpty(this.exceptionPredicates)) {
            String field = this.retryOnAllExceptions ? "retryOnAllExceptions" : "retryOnAllRuntimeExceptions";
            LOG.warn("{} is set while exceptionPredicates is populated: {} takes precedence", (Object)field, (Object)field);
        }
    }

    private WaitStrategy determineWaitStrategy() {
        return Optional.ofNullable(this.waitStrategy).orElseGet(this::newIncrementingWaitStrategy);
    }

    private WaitStrategy newIncrementingWaitStrategy() {
        return WaitStrategies.incrementingWait((long)this.initialSleepTimeAmount, (TimeUnit)this.initialSleepTimeUnit, (long)this.retryIncrementTimeAmount, (TimeUnit)this.retryIncrementTimeUnit);
    }

    private StopStrategy determineStopStrategy() {
        return Optional.ofNullable(this.stopStrategy).orElseGet(() -> StopStrategies.stopAfterAttempt((int)this.maxAttempts));
    }

    private static <T> String $default$retryerId() {
        return UUIDs.randomUUIDString();
    }

    private static <T> long $default$initialSleepTimeAmount() {
        return 100L;
    }

    private static <T> TimeUnit $default$initialSleepTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private static <T> long $default$retryIncrementTimeAmount() {
        return 200L;
    }

    private static <T> TimeUnit $default$retryIncrementTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private static <T> int $default$maxAttempts() {
        return 5;
    }

    private static <T> Level $default$processingLogLevel() {
        return Level.DEBUG;
    }

    private static <T> Level $default$exceptionLogLevel() {
        return Level.WARN;
    }

    @ConstructorProperties(value={"retryerId", "initialSleepTimeAmount", "initialSleepTimeUnit", "retryIncrementTimeAmount", "retryIncrementTimeUnit", "maxAttempts", "processingLogLevel", "exceptionLogLevel", "retryOnAllExceptions", "retryOnAllRuntimeExceptions", "exceptionPredicates", "resultPredicates", "stopStrategy", "waitStrategy"})
    KiwiRetryer(String retryerId, long initialSleepTimeAmount, TimeUnit initialSleepTimeUnit, long retryIncrementTimeAmount, TimeUnit retryIncrementTimeUnit, int maxAttempts, Level processingLogLevel, Level exceptionLogLevel, boolean retryOnAllExceptions, boolean retryOnAllRuntimeExceptions, List<Predicate<Throwable>> exceptionPredicates, List<Predicate<T>> resultPredicates, StopStrategy stopStrategy, WaitStrategy waitStrategy) {
        this.retryerId = retryerId;
        this.initialSleepTimeAmount = initialSleepTimeAmount;
        this.initialSleepTimeUnit = initialSleepTimeUnit;
        this.retryIncrementTimeAmount = retryIncrementTimeAmount;
        this.retryIncrementTimeUnit = retryIncrementTimeUnit;
        this.maxAttempts = maxAttempts;
        this.processingLogLevel = processingLogLevel;
        this.exceptionLogLevel = exceptionLogLevel;
        this.retryOnAllExceptions = retryOnAllExceptions;
        this.retryOnAllRuntimeExceptions = retryOnAllRuntimeExceptions;
        this.exceptionPredicates = exceptionPredicates;
        this.resultPredicates = resultPredicates;
        this.stopStrategy = stopStrategy;
        this.waitStrategy = waitStrategy;
    }

    public static <T> KiwiRetryerBuilder<T> builder() {
        return new KiwiRetryerBuilder();
    }

    public static class KiwiRetryerBuilder<T> {
        private boolean retryerId$set;
        private String retryerId$value;
        private boolean initialSleepTimeAmount$set;
        private long initialSleepTimeAmount$value;
        private boolean initialSleepTimeUnit$set;
        private TimeUnit initialSleepTimeUnit$value;
        private boolean retryIncrementTimeAmount$set;
        private long retryIncrementTimeAmount$value;
        private boolean retryIncrementTimeUnit$set;
        private TimeUnit retryIncrementTimeUnit$value;
        private boolean maxAttempts$set;
        private int maxAttempts$value;
        private boolean processingLogLevel$set;
        private Level processingLogLevel$value;
        private boolean exceptionLogLevel$set;
        private Level exceptionLogLevel$value;
        private boolean retryOnAllExceptions;
        private boolean retryOnAllRuntimeExceptions;
        private ArrayList<Predicate<Throwable>> exceptionPredicates;
        private ArrayList<Predicate<T>> resultPredicates;
        private StopStrategy stopStrategy;
        private WaitStrategy waitStrategy;

        KiwiRetryerBuilder() {
        }

        public KiwiRetryerBuilder<T> retryerId(String retryerId) {
            this.retryerId$value = retryerId;
            this.retryerId$set = true;
            return this;
        }

        public KiwiRetryerBuilder<T> initialSleepTimeAmount(long initialSleepTimeAmount) {
            this.initialSleepTimeAmount$value = initialSleepTimeAmount;
            this.initialSleepTimeAmount$set = true;
            return this;
        }

        public KiwiRetryerBuilder<T> initialSleepTimeUnit(TimeUnit initialSleepTimeUnit) {
            this.initialSleepTimeUnit$value = initialSleepTimeUnit;
            this.initialSleepTimeUnit$set = true;
            return this;
        }

        public KiwiRetryerBuilder<T> retryIncrementTimeAmount(long retryIncrementTimeAmount) {
            this.retryIncrementTimeAmount$value = retryIncrementTimeAmount;
            this.retryIncrementTimeAmount$set = true;
            return this;
        }

        public KiwiRetryerBuilder<T> retryIncrementTimeUnit(TimeUnit retryIncrementTimeUnit) {
            this.retryIncrementTimeUnit$value = retryIncrementTimeUnit;
            this.retryIncrementTimeUnit$set = true;
            return this;
        }

        public KiwiRetryerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts$value = maxAttempts;
            this.maxAttempts$set = true;
            return this;
        }

        public KiwiRetryerBuilder<T> processingLogLevel(Level processingLogLevel) {
            this.processingLogLevel$value = processingLogLevel;
            this.processingLogLevel$set = true;
            return this;
        }

        public KiwiRetryerBuilder<T> exceptionLogLevel(Level exceptionLogLevel) {
            this.exceptionLogLevel$value = exceptionLogLevel;
            this.exceptionLogLevel$set = true;
            return this;
        }

        public KiwiRetryerBuilder<T> retryOnAllExceptions(boolean retryOnAllExceptions) {
            this.retryOnAllExceptions = retryOnAllExceptions;
            return this;
        }

        public KiwiRetryerBuilder<T> retryOnAllRuntimeExceptions(boolean retryOnAllRuntimeExceptions) {
            this.retryOnAllRuntimeExceptions = retryOnAllRuntimeExceptions;
            return this;
        }

        public KiwiRetryerBuilder<T> exceptionPredicate(Predicate<Throwable> exceptionPredicate) {
            if (this.exceptionPredicates == null) {
                this.exceptionPredicates = new ArrayList();
            }
            this.exceptionPredicates.add(exceptionPredicate);
            return this;
        }

        public KiwiRetryerBuilder<T> exceptionPredicates(Collection<? extends Predicate<Throwable>> exceptionPredicates) {
            if (exceptionPredicates == null) {
                throw new NullPointerException("exceptionPredicates cannot be null");
            }
            if (this.exceptionPredicates == null) {
                this.exceptionPredicates = new ArrayList();
            }
            this.exceptionPredicates.addAll(exceptionPredicates);
            return this;
        }

        public KiwiRetryerBuilder<T> clearExceptionPredicates() {
            if (this.exceptionPredicates != null) {
                this.exceptionPredicates.clear();
            }
            return this;
        }

        public KiwiRetryerBuilder<T> resultPredicate(Predicate<T> resultPredicate) {
            if (this.resultPredicates == null) {
                this.resultPredicates = new ArrayList();
            }
            this.resultPredicates.add(resultPredicate);
            return this;
        }

        public KiwiRetryerBuilder<T> resultPredicates(Collection<? extends Predicate<T>> resultPredicates) {
            if (resultPredicates == null) {
                throw new NullPointerException("resultPredicates cannot be null");
            }
            if (this.resultPredicates == null) {
                this.resultPredicates = new ArrayList();
            }
            this.resultPredicates.addAll(resultPredicates);
            return this;
        }

        public KiwiRetryerBuilder<T> clearResultPredicates() {
            if (this.resultPredicates != null) {
                this.resultPredicates.clear();
            }
            return this;
        }

        public KiwiRetryerBuilder<T> stopStrategy(StopStrategy stopStrategy) {
            this.stopStrategy = stopStrategy;
            return this;
        }

        public KiwiRetryerBuilder<T> waitStrategy(WaitStrategy waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        public KiwiRetryer<T> build() {
            List resultPredicates;
            List<Predicate<Throwable>> exceptionPredicates;
            switch (this.exceptionPredicates == null ? 0 : this.exceptionPredicates.size()) {
                case 0: {
                    exceptionPredicates = Collections.emptyList();
                    break;
                }
                case 1: {
                    exceptionPredicates = Collections.singletonList(this.exceptionPredicates.get(0));
                    break;
                }
                default: {
                    exceptionPredicates = Collections.unmodifiableList(new ArrayList<Predicate<Throwable>>(this.exceptionPredicates));
                }
            }
            switch (this.resultPredicates == null ? 0 : this.resultPredicates.size()) {
                case 0: {
                    resultPredicates = Collections.emptyList();
                    break;
                }
                case 1: {
                    resultPredicates = Collections.singletonList(this.resultPredicates.get(0));
                    break;
                }
                default: {
                    resultPredicates = Collections.unmodifiableList(new ArrayList<Predicate<T>>(this.resultPredicates));
                }
            }
            String retryerId$value = this.retryerId$value;
            if (!this.retryerId$set) {
                retryerId$value = KiwiRetryer.$default$retryerId();
            }
            long initialSleepTimeAmount$value = this.initialSleepTimeAmount$value;
            if (!this.initialSleepTimeAmount$set) {
                initialSleepTimeAmount$value = KiwiRetryer.$default$initialSleepTimeAmount();
            }
            TimeUnit initialSleepTimeUnit$value = this.initialSleepTimeUnit$value;
            if (!this.initialSleepTimeUnit$set) {
                initialSleepTimeUnit$value = KiwiRetryer.$default$initialSleepTimeUnit();
            }
            long retryIncrementTimeAmount$value = this.retryIncrementTimeAmount$value;
            if (!this.retryIncrementTimeAmount$set) {
                retryIncrementTimeAmount$value = KiwiRetryer.$default$retryIncrementTimeAmount();
            }
            TimeUnit retryIncrementTimeUnit$value = this.retryIncrementTimeUnit$value;
            if (!this.retryIncrementTimeUnit$set) {
                retryIncrementTimeUnit$value = KiwiRetryer.$default$retryIncrementTimeUnit();
            }
            int maxAttempts$value = this.maxAttempts$value;
            if (!this.maxAttempts$set) {
                maxAttempts$value = KiwiRetryer.$default$maxAttempts();
            }
            Level processingLogLevel$value = this.processingLogLevel$value;
            if (!this.processingLogLevel$set) {
                processingLogLevel$value = KiwiRetryer.$default$processingLogLevel();
            }
            Level exceptionLogLevel$value = this.exceptionLogLevel$value;
            if (!this.exceptionLogLevel$set) {
                exceptionLogLevel$value = KiwiRetryer.$default$exceptionLogLevel();
            }
            return new KiwiRetryer(retryerId$value, initialSleepTimeAmount$value, initialSleepTimeUnit$value, retryIncrementTimeAmount$value, retryIncrementTimeUnit$value, maxAttempts$value, processingLogLevel$value, exceptionLogLevel$value, this.retryOnAllExceptions, this.retryOnAllRuntimeExceptions, exceptionPredicates, resultPredicates, this.stopStrategy, this.waitStrategy);
        }

        public String toString() {
            return "KiwiRetryer.KiwiRetryerBuilder(retryerId$value=" + this.retryerId$value + ", initialSleepTimeAmount$value=" + this.initialSleepTimeAmount$value + ", initialSleepTimeUnit$value=" + this.initialSleepTimeUnit$value + ", retryIncrementTimeAmount$value=" + this.retryIncrementTimeAmount$value + ", retryIncrementTimeUnit$value=" + this.retryIncrementTimeUnit$value + ", maxAttempts$value=" + this.maxAttempts$value + ", processingLogLevel$value=" + this.processingLogLevel$value + ", exceptionLogLevel$value=" + this.exceptionLogLevel$value + ", retryOnAllExceptions=" + this.retryOnAllExceptions + ", retryOnAllRuntimeExceptions=" + this.retryOnAllRuntimeExceptions + ", exceptionPredicates=" + this.exceptionPredicates + ", resultPredicates=" + this.resultPredicates + ", stopStrategy=" + this.stopStrategy + ", waitStrategy=" + this.waitStrategy + ")";
        }
    }

    static class LoggingRetryListener
    implements RetryListener {
        private static final String RETRY_ATTEMPT_MSG = "Retryer [{}], attempt #{} [delay since first attempt: {} ms]";
        private static final String RESULT_MSG = "Result for retryer [{}]: {}";
        private static final String EXCEPTION_MESSAGE = "Exception occurred for retryer [{}]: {}: {}";
        private final String retryId;
        private final Level processingLogLevel;
        private final Level exceptionLogLevel;

        LoggingRetryListener(String id, Level processingLogLevel, Level exceptionLogLevel) {
            this.retryId = StringUtils.isBlank((CharSequence)id) ? UUIDs.randomUUIDString() : id;
            this.processingLogLevel = processingLogLevel;
            this.exceptionLogLevel = exceptionLogLevel;
        }

        public <V> void onRetry(Attempt<V> attempt) {
            long attemptNumber = attempt.getAttemptNumber();
            RetryLogger.logAttempt(LOG, this.processingLogLevel, attemptNumber, RETRY_ATTEMPT_MSG, this.retryId, attemptNumber, attempt.getDelaySinceFirstAttempt());
            if (attempt.hasResult()) {
                this.logResultAttempt(attempt, attemptNumber);
            } else if (attempt.hasException()) {
                this.logExceptionAttempt(attempt);
            }
        }

        <V> void logResultAttempt(Attempt<V> attempt, long attemptNumber) {
            RetryLogger.logAttempt(LOG, this.processingLogLevel, attemptNumber, RESULT_MSG, this.retryId, attempt.getResult());
        }

        <V> void logExceptionAttempt(Attempt<V> attempt) {
            Throwable throwable = attempt.getExceptionCause();
            String type = KiwiThrowables.typeOfNullable(throwable).orElse(null);
            String message = KiwiThrowables.messageOfNullable(throwable).orElse(null);
            RetryLogger.logAttempt(LOG, this.exceptionLogLevel, EXCEPTION_MESSAGE, this.retryId, type, message);
        }
    }
}

