/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import com.github.rholder.retry.RetryException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.kiwiproject.base.KiwiPreconditions;

public class KiwiRetryerException
extends RuntimeException {
    public KiwiRetryerException(String message, Throwable cause) {
        super(message, KiwiPreconditions.requireNotNull(cause, "cause is required", new Object[0]));
    }

    public static Optional<Throwable> unwrapKiwiRetryerException(KiwiRetryerException kiwiRetryerEx) {
        Throwable cause = kiwiRetryerEx.getCause();
        if (cause instanceof ExecutionException) {
            ExecutionException executionException = (ExecutionException)cause;
            return Optional.ofNullable(executionException.getCause());
        }
        return Optional.of(cause);
    }

    public static Optional<Throwable> unwrapKiwiRetryerExceptionFully(KiwiRetryerException kiwiRetryerEx) {
        Throwable throwable = KiwiRetryerException.unwrapKiwiRetryerException(kiwiRetryerEx).orElse(null);
        if (throwable instanceof RetryException) {
            return Optional.ofNullable(throwable.getCause());
        }
        return Optional.ofNullable(throwable);
    }

    public Optional<Throwable> unwrap() {
        return KiwiRetryerException.unwrapKiwiRetryerException(this);
    }

    public Optional<Throwable> unwrapFully() {
        return KiwiRetryerException.unwrapKiwiRetryerExceptionFully(this);
    }
}

