/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.retry.RetryResult;
import org.slf4j.Logger;

public final class RetryResultLogger {
    private static final String NO_ERRORS_TO_LOG = "no errors to log";

    public static <T> void logSummaryIfFailed(RetryResult<T> result, Logger logger, Supplier<String> actionDescriptionSupplier) {
        RetryResultLogger.checkArgumentsNotNull(result, logger);
        if (result.failed()) {
            RetryResultLogger.logSummaryWithDescriptionSupplier(result, logger, actionDescriptionSupplier);
        }
    }

    public static <T> void logSummaryIfHasErrorsOrMultipleAttempts(RetryResult<T> result, Logger logger, Supplier<String> actionDescriptionSupplier) {
        RetryResultLogger.checkArgumentsNotNull(result, logger);
        if (result.hasAnyErrors() || result.hasMoreThanOneAttempt()) {
            RetryResultLogger.logSummaryWithDescriptionSupplier(result, logger, actionDescriptionSupplier);
        }
    }

    private static <T> void logSummaryWithDescriptionSupplier(RetryResult<T> result, Logger logger, Supplier<String> supplier) {
        String actionDescription = Objects.isNull(supplier) ? "" : supplier.get();
        RetryResultLogger.logSummary(result, logger, actionDescription);
    }

    public static <T> void logSummary(RetryResult<T> result, Logger logger, String actionDescription) {
        RetryResultLogger.checkArgumentsNotNull(result, logger);
        if (result.failed()) {
            RetryResultLogger.logFailureSummary(result, logger, actionDescription);
        } else {
            RetryResultLogger.logSuccessSummary(result, logger, actionDescription);
        }
    }

    private static <T> void logFailureSummary(RetryResult<T> result, Logger logger, String actionDescription) {
        Preconditions.checkArgument((boolean)result.failed(), (Object)"you must only pass a failed result to this method");
        String newActionDescription = RetryResultLogger.buildActionDescription(actionDescription);
        String lastErrorInfo = RetryResultLogger.buildLastErrorDescription(result);
        logger.error("Result {}: {} FAILED after {} attempts with {} errors. Unique error types: {}. Last error type/message: {}", new Object[]{result.getResultUuid(), newActionDescription, result.getNumAttemptsMade(), result.getNumErrors(), result.getUniqueErrorTypes(), lastErrorInfo});
    }

    private static <T> void logSuccessSummary(RetryResult<T> result, Logger logger, String actionDescription) {
        Preconditions.checkArgument((boolean)result.succeeded(), (Object)"you must only pass a successful result to this method");
        String newActionDescription = RetryResultLogger.buildActionDescription(actionDescription);
        if (result.hasAnyErrors()) {
            String lastErrorInfo = RetryResultLogger.buildLastErrorDescription(result);
            logger.warn("Result {}: {} SUCCEEDED after {} attempts with {} errors. Unique error types: {}. Last error type/message: {}", new Object[]{result.getResultUuid(), newActionDescription, result.getNumAttemptsMade(), result.getNumErrors(), result.getUniqueErrorTypes(), lastErrorInfo});
        } else {
            logger.debug("Result {}: {} SUCCEEDED after {} attempts with no errors.", new Object[]{result.getResultUuid(), newActionDescription, result.getNumAttemptsMade()});
        }
    }

    private static String buildActionDescription(String summaryText) {
        return StringUtils.isBlank((CharSequence)summaryText) ? "" : "[" + summaryText + "]";
    }

    private static <T> String buildLastErrorDescription(RetryResult<T> result) {
        Exception lastError = result.getLastErrorIfPresent().orElse(null);
        return Objects.isNull(lastError) ? "[none]" : lastError.getClass().getName() + " / " + lastError.getMessage();
    }

    public static <T> void logAllExceptions(RetryResult<T> result, Logger logger) {
        RetryResultLogger.logCommonResultInfo(result, logger, "all errors logged below");
        if (!result.hasAnyErrors()) {
            return;
        }
        String uuid = result.getResultUuid();
        int numErrors = result.getNumErrors();
        List<Exception> errors = result.getErrors();
        IntStream.rangeClosed(1, numErrors).forEachOrdered(i -> {
            Exception error = (Exception)KiwiLists.nth(errors, i);
            logger.error("Result {}: error #{} of {}:", new Object[]{uuid, i, numErrors, error});
        });
    }

    public static <T> void logLastException(RetryResult<T> result, Logger logger) {
        RetryResultLogger.logCommonResultInfo(result, logger, "last error logged below");
        RetryResultLogger.logLastErrorIfPresent(result, logger);
    }

    public static <T> void logExceptionTypesAndLast(RetryResult<T> result, Logger logger) {
        RetryResultLogger.logCommonResultInfo(result, logger, "error types and last error logged below");
        Set<String> uniqueTypes = result.getUniqueErrorTypes();
        logger.error("Result {}: {} unique error types: {}", new Object[]{result.getResultUuid(), uniqueTypes.size(), uniqueTypes});
        RetryResultLogger.logLastErrorIfPresent(result, logger);
    }

    private static <T> void logCommonResultInfo(RetryResult<T> result, Logger logger, String customErrorTypeMessage) {
        RetryResultLogger.checkArgumentsNotNull(result, logger);
        String displayMessage = result.hasAnyErrors() ? customErrorTypeMessage : NO_ERRORS_TO_LOG;
        logger.error("Result {}: attempts: {}, maxAttempts: {}, hasObject: {}, hasErrors: {}, numErrors: {} ({})", new Object[]{result.getResultUuid(), result.getNumAttemptsMade(), result.getMaxAttempts(), result.hasObject(), result.hasAnyErrors(), result.getNumErrors(), displayMessage});
    }

    private static <T> void checkArgumentsNotNull(RetryResult<T> result, Logger logger) {
        KiwiPreconditions.checkArgumentNotNull(result, "result cannot be null");
        KiwiPreconditions.checkArgumentNotNull(logger, "logger cannot be null");
    }

    private static <T> void logLastErrorIfPresent(RetryResult<T> result, Logger logger) {
        result.getLastErrorIfPresent().ifPresent(lastError -> logger.error("Result {}: last error (of {} total errors):", new Object[]{result.getResultUuid(), result.getNumErrors(), lastError}));
    }

    private RetryResultLogger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

