/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import com.google.common.annotations.VisibleForTesting;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.kiwiproject.base.DefaultEnvironment;
import org.kiwiproject.base.KiwiEnvironment;
import org.kiwiproject.retry.RetryResult;
import org.kiwiproject.retry.SimpleRetries;
import org.slf4j.event.Level;

public class SimpleRetryer {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final long DEFAULT_RETRY_DELAY_TIME = 50L;
    public static final TimeUnit DEFAULT_RETRY_DELAY_UNIT = TimeUnit.MILLISECONDS;
    public static final String DEFAULT_TYPE = "object";
    @VisibleForTesting
    KiwiEnvironment environment;
    @VisibleForTesting
    int maxAttempts;
    @VisibleForTesting
    long retryDelayTime;
    @VisibleForTesting
    TimeUnit retryDelayUnit;
    @VisibleForTesting
    String commonType;
    @VisibleForTesting
    Level logLevelForSubsequentAttempts;

    public <T> Optional<T> tryGetObject(Supplier<T> supplier) {
        return this.tryGetObject(this.commonType, supplier);
    }

    public <T> Optional<T> tryGetObject(Class<T> type, Supplier<T> supplier) {
        return this.tryGetObject(type.getSimpleName(), supplier);
    }

    public <T> Optional<T> tryGetObject(String type, Supplier<T> supplier) {
        return SimpleRetries.tryGetObject(this.maxAttempts, this.retryDelayTime, this.retryDelayUnit, this.environment, type, this.logLevelForSubsequentAttempts, supplier);
    }

    public <T> RetryResult<T> tryGetObjectCollectingErrors(Supplier<T> supplier) {
        return this.tryGetObjectCollectingErrors(this.commonType, supplier);
    }

    public <T> RetryResult<T> tryGetObjectCollectingErrors(Class<T> type, Supplier<T> supplier) {
        return this.tryGetObjectCollectingErrors(type.getSimpleName(), supplier);
    }

    public <T> RetryResult<T> tryGetObjectCollectingErrors(String type, Supplier<T> supplier) {
        return SimpleRetries.tryGetObjectCollectingErrors(this.maxAttempts, this.retryDelayTime, this.retryDelayUnit, this.environment, type, supplier);
    }

    private static KiwiEnvironment $default$environment() {
        return new DefaultEnvironment();
    }

    private static int $default$maxAttempts() {
        return 3;
    }

    private static long $default$retryDelayTime() {
        return 50L;
    }

    private static TimeUnit $default$retryDelayUnit() {
        return DEFAULT_RETRY_DELAY_UNIT;
    }

    private static String $default$commonType() {
        return DEFAULT_TYPE;
    }

    private static Level $default$logLevelForSubsequentAttempts() {
        return Level.TRACE;
    }

    @ConstructorProperties(value={"environment", "maxAttempts", "retryDelayTime", "retryDelayUnit", "commonType", "logLevelForSubsequentAttempts"})
    SimpleRetryer(KiwiEnvironment environment, int maxAttempts, long retryDelayTime, TimeUnit retryDelayUnit, String commonType, Level logLevelForSubsequentAttempts) {
        this.environment = environment;
        this.maxAttempts = maxAttempts;
        this.retryDelayTime = retryDelayTime;
        this.retryDelayUnit = retryDelayUnit;
        this.commonType = commonType;
        this.logLevelForSubsequentAttempts = logLevelForSubsequentAttempts;
    }

    public static SimpleRetryerBuilder builder() {
        return new SimpleRetryerBuilder();
    }

    public static class SimpleRetryerBuilder {
        private boolean environment$set;
        private KiwiEnvironment environment$value;
        private boolean maxAttempts$set;
        private int maxAttempts$value;
        private boolean retryDelayTime$set;
        private long retryDelayTime$value;
        private boolean retryDelayUnit$set;
        private TimeUnit retryDelayUnit$value;
        private boolean commonType$set;
        private String commonType$value;
        private boolean logLevelForSubsequentAttempts$set;
        private Level logLevelForSubsequentAttempts$value;

        SimpleRetryerBuilder() {
        }

        public SimpleRetryerBuilder environment(KiwiEnvironment environment) {
            this.environment$value = environment;
            this.environment$set = true;
            return this;
        }

        public SimpleRetryerBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts$value = maxAttempts;
            this.maxAttempts$set = true;
            return this;
        }

        public SimpleRetryerBuilder retryDelayTime(long retryDelayTime) {
            this.retryDelayTime$value = retryDelayTime;
            this.retryDelayTime$set = true;
            return this;
        }

        public SimpleRetryerBuilder retryDelayUnit(TimeUnit retryDelayUnit) {
            this.retryDelayUnit$value = retryDelayUnit;
            this.retryDelayUnit$set = true;
            return this;
        }

        public SimpleRetryerBuilder commonType(String commonType) {
            this.commonType$value = commonType;
            this.commonType$set = true;
            return this;
        }

        public SimpleRetryerBuilder logLevelForSubsequentAttempts(Level logLevelForSubsequentAttempts) {
            this.logLevelForSubsequentAttempts$value = logLevelForSubsequentAttempts;
            this.logLevelForSubsequentAttempts$set = true;
            return this;
        }

        public SimpleRetryer build() {
            KiwiEnvironment environment$value = this.environment$value;
            if (!this.environment$set) {
                environment$value = SimpleRetryer.$default$environment();
            }
            int maxAttempts$value = this.maxAttempts$value;
            if (!this.maxAttempts$set) {
                maxAttempts$value = SimpleRetryer.$default$maxAttempts();
            }
            long retryDelayTime$value = this.retryDelayTime$value;
            if (!this.retryDelayTime$set) {
                retryDelayTime$value = SimpleRetryer.$default$retryDelayTime();
            }
            TimeUnit retryDelayUnit$value = this.retryDelayUnit$value;
            if (!this.retryDelayUnit$set) {
                retryDelayUnit$value = SimpleRetryer.$default$retryDelayUnit();
            }
            String commonType$value = this.commonType$value;
            if (!this.commonType$set) {
                commonType$value = SimpleRetryer.$default$commonType();
            }
            Level logLevelForSubsequentAttempts$value = this.logLevelForSubsequentAttempts$value;
            if (!this.logLevelForSubsequentAttempts$set) {
                logLevelForSubsequentAttempts$value = SimpleRetryer.$default$logLevelForSubsequentAttempts();
            }
            return new SimpleRetryer(environment$value, maxAttempts$value, retryDelayTime$value, retryDelayUnit$value, commonType$value, logLevelForSubsequentAttempts$value);
        }

        public String toString() {
            return "SimpleRetryer.SimpleRetryerBuilder(environment$value=" + this.environment$value + ", maxAttempts$value=" + this.maxAttempts$value + ", retryDelayTime$value=" + this.retryDelayTime$value + ", retryDelayUnit$value=" + this.retryDelayUnit$value + ", commonType$value=" + this.commonType$value + ", logLevelForSubsequentAttempts$value=" + this.logLevelForSubsequentAttempts$value + ")";
        }
    }
}

