/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.time.KiwiDateTimeConverters;

public final class KiwiDateTimeParsers {
    public static Date parseAsDate(String dateTimeString) {
        KiwiPreconditions.checkArgumentNotBlank(dateTimeString);
        return KiwiDateTimeConverters.toDate(KiwiDateTimeParsers.parseAsZonedDateTime(dateTimeString));
    }

    public static LocalDate parseAsLocalDate(String dateString) {
        return KiwiDateTimeParsers.parseAsLocalDate(dateString, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate parseAsLocalDate(String dateString, DateTimeFormatter formatter) {
        KiwiPreconditions.checkArgumentNotBlank(dateString);
        KiwiPreconditions.checkArgumentNotNull(formatter);
        return formatter.parse((CharSequence)dateString, LocalDate::from);
    }

    public static LocalDateTime parseAsLocalDateTime(String dateTimeString) {
        return KiwiDateTimeParsers.parseAsLocalDateTime(dateTimeString, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static LocalDateTime parseAsLocalDateTime(String dateTimeString, DateTimeFormatter formatter) {
        KiwiPreconditions.checkArgumentNotBlank(dateTimeString);
        KiwiPreconditions.checkArgumentNotNull(formatter);
        return formatter.parse((CharSequence)dateTimeString, LocalDateTime::from);
    }

    public static ZonedDateTime parseAsZonedDateTime(String dateTimeString) {
        return KiwiDateTimeParsers.parseAsZonedDateTime(dateTimeString, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static ZonedDateTime parseAsZonedDateTime(String dateTimeString, DateTimeFormatter formatter) {
        KiwiPreconditions.checkArgumentNotBlank(dateTimeString);
        KiwiPreconditions.checkArgumentNotNull(formatter);
        return formatter.parse((CharSequence)dateTimeString, ZonedDateTime::from);
    }

    private KiwiDateTimeParsers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

