/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import com.google.common.base.Verify;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.validation.FieldRange;
import org.kiwiproject.validation.InternalKiwiValidators;
import org.kiwiproject.validation.KiwiValidations;
import org.kiwiproject.validation.Validity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRangeValidator
implements ConstraintValidator<FieldRange, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldRangeValidator.class);
    private static final String TEMPLATE_BETWEEN = "{org.kiwiproject.validation.FieldRange.between.message}";
    private static final String TEMPLATE_MIN_ONLY = "{org.kiwiproject.validation.FieldRange.minOnly.message}";
    private static final String TEMPLATE_MAX_ONLY = "{org.kiwiproject.validation.FieldRange.maxOnly.message}";
    private static final String TEMPLATE_AFTER_EXCLUSIVE = "{org.kiwiproject.validation.FieldRange.afterExclusive.message}";
    private static final String TEMPLATE_AFTER_INCLUSIVE = "{org.kiwiproject.validation.FieldRange.afterInclusive.message}";
    private FieldRange fieldRange;

    public void initialize(FieldRange constraintAnnotation) {
        this.fieldRange = constraintAnnotation;
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        Validity validity;
        try {
            Comparable<Object> start = FieldRangeValidator.getFieldValueAsComparable(value, this.fieldRange.startField());
            Comparable<Object> end = FieldRangeValidator.getFieldValueAsComparable(value, this.fieldRange.endField());
            validity = this.checkValidity(start, end, context);
        }
        catch (Exception e) {
            FieldRangeValidator.addUnknownErrorConstraintViolation(context, this.fieldRange);
            FieldRangeValidator.logWarning(value, this.fieldRange, e);
            validity = Validity.INVALID;
        }
        return validity == Validity.VALID;
    }

    private static Comparable<Object> getFieldValueAsComparable(Object value, String fieldName) {
        return (Comparable)KiwiValidations.getPropertyValue(value, fieldName);
    }

    private Validity checkValidity(Comparable<Object> start, Comparable<Object> end, ConstraintValidatorContext context) {
        Validity validity = this.checkMinMax(start, end, context);
        if (validity == Validity.CONTINUE && (validity = this.checkNull(start, end, context)) == Validity.CONTINUE) {
            validity = this.checkRange(start, end, context);
        }
        return validity;
    }

    private Validity checkMinMax(Comparable<Object> start, Comparable<Object> end, ConstraintValidatorContext context) {
        Comparable<?> max;
        Validity validity = Validity.CONTINUE;
        Comparable<?> min = InternalKiwiValidators.toComparableOrNull(this.fieldRange.min(), start);
        if (Objects.nonNull(min) && start.compareTo(min) < 0) {
            String template = StringUtils.isBlank((CharSequence)this.fieldRange.max()) ? TEMPLATE_MIN_ONLY : TEMPLATE_BETWEEN;
            KiwiValidations.addError(context, template, this.fieldRange.startField());
            validity = Validity.INVALID;
        }
        if (Objects.nonNull(max = InternalKiwiValidators.toComparableOrNull(this.fieldRange.max(), end)) && end.compareTo(max) > 0) {
            String template = StringUtils.isBlank((CharSequence)this.fieldRange.min()) ? TEMPLATE_MAX_ONLY : TEMPLATE_BETWEEN;
            KiwiValidations.addError(context, template, this.fieldRange.endField());
            validity = Validity.INVALID;
        }
        return validity;
    }

    private Validity checkNull(Comparable<Object> start, Comparable<Object> end, ConstraintValidatorContext context) {
        Validity startValidity = FieldRangeValidator.checkFieldNullity(start, this.fieldRange.startField(), this.fieldRange.allowNullStart(), context);
        Validity endValidity = FieldRangeValidator.checkFieldNullity(end, this.fieldRange.endField(), this.fieldRange.allowNullEnd(), context);
        if (startValidity == Validity.INVALID || endValidity == Validity.INVALID) {
            return Validity.INVALID;
        }
        if (Objects.isNull(start) || Objects.isNull(end)) {
            return Validity.VALID;
        }
        return Validity.CONTINUE;
    }

    private static Validity checkFieldNullity(Comparable<Object> comparable, String field, boolean allowNull, ConstraintValidatorContext context) {
        if (Objects.nonNull(comparable) || allowNull) {
            return Validity.CONTINUE;
        }
        KiwiValidations.addError(context, "{org.kiwiproject.validation.Required.message}", field);
        return Validity.INVALID;
    }

    private Validity checkRange(Comparable<Object> start, Comparable<Object> end, ConstraintValidatorContext context) {
        Verify.verify((boolean)Objects.nonNull(start), (String)"start should not be null at this point; checkNull should not have returned CONTINUE!", (Object[])new Object[0]);
        Verify.verify((boolean)Objects.nonNull(end), (String)"end should not be null at this point; checkNull should not have returned CONTINUE!", (Object[])new Object[0]);
        Validity validity = Validity.VALID;
        if (this.fieldRange.allowStartToEqualEnd()) {
            if (start.compareTo(end) > 0) {
                KiwiValidations.addError(context, TEMPLATE_AFTER_INCLUSIVE, this.fieldRange.startField());
                validity = Validity.INVALID;
            }
        } else if (start.compareTo(end) >= 0) {
            KiwiValidations.addError(context, TEMPLATE_AFTER_EXCLUSIVE, this.fieldRange.startField());
            validity = Validity.INVALID;
        }
        return validity;
    }

    private static void addUnknownErrorConstraintViolation(ConstraintValidatorContext context, FieldRange fieldRange) {
        KiwiValidations.addError(context, "unknown validation error", fieldRange.startField());
    }

    private static void logWarning(Object value, FieldRange fieldRange, Exception e) {
        String valueAsString = Objects.isNull(value) ? "null" : value.getClass().getName();
        LOG.warn("Error validating FieldRange with startField: {}, endField: {}, for value: {}; considering invalid", new Object[]{fieldRange.startField(), fieldRange.endField(), valueAsString, e});
    }
}

