/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiSets;

public final class KiwiConstraintViolations {
    public static <T> String simpleCombinedErrorMessage(Set<ConstraintViolation<T>> violations) {
        return KiwiConstraintViolations.combinedErrorMessage(violations, Objects::toString);
    }

    public static <T> String prettyCombinedErrorMessage(Set<ConstraintViolation<T>> violations) {
        return KiwiConstraintViolations.combinedErrorMessage(violations, KiwiConstraintViolations::humanize);
    }

    public static <T> String combinedErrorMessage(Set<ConstraintViolation<T>> violations, Function<Path, String> pathTransformer) {
        KiwiConstraintViolations.checkArgumentsForCombining(violations);
        KiwiPreconditions.checkArgumentNotNull(pathTransformer);
        return violations.stream().map(violation -> KiwiConstraintViolations.propertyAndErrorMessage(violation, pathTransformer)).sorted().collect(Collectors.joining(", "));
    }

    public static <T> List<String> simpleCombinedErrorMessages(Set<ConstraintViolation<T>> violations) {
        return KiwiConstraintViolations.combinedErrorMessages(violations, Objects::toString);
    }

    public static <T> List<String> prettyCombinedErrorMessages(Set<ConstraintViolation<T>> violations) {
        return KiwiConstraintViolations.combinedErrorMessages(violations, KiwiConstraintViolations::humanize);
    }

    public static <T> List<String> combinedErrorMessages(Set<ConstraintViolation<T>> violations, Function<Path, String> pathTransformer) {
        KiwiConstraintViolations.checkArgumentsForCombining(violations);
        KiwiPreconditions.checkArgumentNotNull(pathTransformer);
        return violations.stream().map(violation -> KiwiConstraintViolations.propertyAndErrorMessage(violation, pathTransformer)).sorted().collect(Collectors.toList());
    }

    public static <T> Map<String, String> simpleCombineErrorMessagesIntoMap(Set<ConstraintViolation<T>> violations) {
        return KiwiConstraintViolations.combineErrorMessagesIntoMap(violations, Objects::toString);
    }

    public static <T> Map<String, String> prettyCombineErrorMessagesIntoMap(Set<ConstraintViolation<T>> violations) {
        return KiwiConstraintViolations.combineErrorMessagesIntoMap(violations, KiwiConstraintViolations::humanize);
    }

    public static <T> Map<String, String> combineErrorMessagesIntoMap(Set<ConstraintViolation<T>> violations, Function<Path, String> pathTransformer) {
        KiwiConstraintViolations.checkArgumentsForCombining(violations);
        KiwiPreconditions.checkArgumentNotNull(pathTransformer);
        return violations.stream().collect(Collectors.toMap(violation -> (String)pathTransformer.apply(violation.getPropertyPath()), ConstraintViolation::getMessage, (accumulatedMessage, newErrorMessage) -> accumulatedMessage + ", " + newErrorMessage));
    }

    public static String humanize(Path propertyPath) {
        return KiwiConstraintViolations.humanize(propertyPath, "/");
    }

    public static String humanize(Path propertyPath, String pathSeparator) {
        KiwiPreconditions.checkArgumentNotNull(propertyPath, "propertyPath must not be null");
        KiwiPreconditions.checkArgumentNotNull(pathSeparator, "pathSeparator must not be null");
        String[] splat = StringUtils.splitByCharacterTypeCamelCase((String)propertyPath.toString());
        String joined = Arrays.stream(splat).map(str -> ".".equals(str) ? pathSeparator : str).collect(Collectors.joining(" "));
        return WordUtils.capitalize((String)joined);
    }

    private static <T> void checkArgumentsForCombining(Set<ConstraintViolation<T>> violations) {
        Preconditions.checkArgument((boolean)KiwiSets.isNotNullOrEmpty(violations), (Object)"There are no violations to combine");
    }

    private static <T> String propertyAndErrorMessage(ConstraintViolation<T> violation, Function<Path, String> pathTransformer) {
        return pathTransformer.apply(violation.getPropertyPath()) + " " + violation.getMessage();
    }

    private KiwiConstraintViolations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

