/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import java.util.Set;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.kiwiproject.reflect.KiwiReflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiValidations {
    private static final Logger LOG = LoggerFactory.getLogger(KiwiValidations.class);
    private static Validator validatorInstance = KiwiValidations.newValidator();

    public static Validator newValidator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    public static Validator getValidator() {
        return validatorInstance;
    }

    public static void setValidator(Validator newValidator) {
        LOG.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        LOG.warn("               Overriding static Validator instance             !!!");
        LOG.warn("!!! You should only see this in tests or an application startup !!!");
        LOG.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        validatorInstance = newValidator;
    }

    public static <T> Set<ConstraintViolation<T>> validate(T object) {
        return validatorInstance.validate(object, new Class[]{Default.class});
    }

    public static <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groupClasses) {
        return validatorInstance.validate(object, (Class[])groupClasses);
    }

    public static void addError(ConstraintValidatorContext context, String template) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(template).addConstraintViolation();
    }

    public static void addError(ConstraintValidatorContext context, String template, String propertyName) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(template).addPropertyNode(propertyName).addConstraintViolation();
    }

    public static Object getPropertyValue(Object bean, String fieldName) {
        try {
            return KiwiReflection.findField(bean, fieldName).get(bean);
        }
        catch (Exception e) {
            LOG.warn("Unable to get property value {} from object {}", new Object[]{fieldName, bean, e});
            return null;
        }
    }

    private KiwiValidations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

