/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.validation.Required;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredValidator
implements ConstraintValidator<Required, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RequiredValidator.class);
    private boolean allowBlank;
    private boolean allowEmpty;

    public void initialize(Required constraintAnnotation) {
        this.allowBlank = constraintAnnotation.allowBlank();
        this.allowEmpty = constraintAnnotation.allowEmpty();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        return !Objects.isNull(value) && !this.notAllowingBlanksButIsBlank(value) && !this.notAllowingEmptyButIsEmpty(value);
    }

    private boolean notAllowingBlanksButIsBlank(Object value) {
        return !this.allowBlank && RequiredValidator.isBlank(value);
    }

    private static boolean isBlank(Object value) {
        return value instanceof CharSequence && StringUtils.isBlank((CharSequence)((CharSequence)value));
    }

    private boolean notAllowingEmptyButIsEmpty(Object value) {
        return !this.allowEmpty && RequiredValidator.isEmpty(value);
    }

    private static boolean isEmpty(@Nonnull Object value) {
        Objects.requireNonNull(value);
        if (value instanceof CharSequence) {
            return StringUtils.isEmpty((CharSequence)((CharSequence)value));
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        try {
            Method isEmptyMethod = RequiredValidator.findIsEmptyMethod(value).orElse(null);
            if (Objects.isNull(isEmptyMethod)) {
                return false;
            }
            return (Boolean)isEmptyMethod.invoke(value, new Object[0]);
        }
        catch (Exception e) {
            LOG.trace("Error invoking isEmpty method; assuming not empty", (Throwable)e);
            return false;
        }
    }

    private static Optional<Method> findIsEmptyMethod(Object value) {
        return Arrays.stream(value.getClass().getMethods()).filter(method -> method.getName().equals("isEmpty")).filter(method -> method.getParameterCount() == 0).filter(method -> method.getReturnType().equals(Boolean.TYPE)).findFirst();
    }
}

