/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.xml;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kiwiproject.base.KiwiPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiXmlConverters {
    private static final Logger LOG = LoggerFactory.getLogger(KiwiXmlConverters.class);
    private static final DatatypeFactory FACTORY;

    public static XMLGregorianCalendar newXMLGregorianCalendar() {
        return KiwiXmlConverters.newXMLGregorianCalendar(ZoneId.systemDefault());
    }

    public static XMLGregorianCalendar newXMLGregorianCalendarUTC() {
        return KiwiXmlConverters.newXMLGregorianCalendar(ZoneOffset.UTC);
    }

    public static XMLGregorianCalendar newXMLGregorianCalendar(ZoneId zoneId) {
        return FACTORY.newXMLGregorianCalendar(new GregorianCalendar(TimeZone.getTimeZone(zoneId)));
    }

    public static XMLGregorianCalendar epochMillisToXMLGregorianCalendar(long epochMillis) {
        return KiwiXmlConverters.epochMillisToXMLGregorianCalendar(epochMillis, ZoneId.systemDefault());
    }

    public static XMLGregorianCalendar epochMillisToXMLGregorianCalendarUTC(long epochMillis) {
        return KiwiXmlConverters.epochMillisToXMLGregorianCalendar(epochMillis, ZoneOffset.UTC);
    }

    public static XMLGregorianCalendar epochMillisToXMLGregorianCalendar(long epochMillis, ZoneId zoneId) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone(zoneId));
        calendar.setTimeInMillis(epochMillis);
        return FACTORY.newXMLGregorianCalendar(calendar);
    }

    public static XMLGregorianCalendar instantToXMLGregorianCalendar(Instant instant) {
        return KiwiXmlConverters.instantToXMLGregorianCalendar(instant, ZoneId.systemDefault());
    }

    public static XMLGregorianCalendar instantToXMLGregorianCalendarUTC(Instant instant) {
        return KiwiXmlConverters.instantToXMLGregorianCalendar(instant, ZoneOffset.UTC);
    }

    public static XMLGregorianCalendar instantToXMLGregorianCalendar(Instant instant, ZoneId zoneId) {
        KiwiPreconditions.checkArgumentNotNull(instant);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone(zoneId));
        calendar.setTimeInMillis(instant.toEpochMilli());
        return FACTORY.newXMLGregorianCalendar(calendar);
    }

    public static XMLGregorianCalendar dateToXMLGregorianCalendar(Date date) {
        return KiwiXmlConverters.dateToXMLGregorianCalendar(date, ZoneId.systemDefault());
    }

    public static XMLGregorianCalendar dateToXMLGregorianCalendarUTC(Date date) {
        return KiwiXmlConverters.dateToXMLGregorianCalendar(date, ZoneOffset.UTC);
    }

    public static XMLGregorianCalendar dateToXMLGregorianCalendar(Date date, ZoneId zoneId) {
        KiwiPreconditions.checkArgumentNotNull(date);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone(zoneId));
        calendar.setTime(date);
        return FACTORY.newXMLGregorianCalendar(calendar);
    }

    public static Instant xmlGregorianCalendarToInstant(XMLGregorianCalendar xmlGregorianCalendar) {
        KiwiPreconditions.checkArgumentNotNull(xmlGregorianCalendar);
        return xmlGregorianCalendar.toGregorianCalendar().toInstant();
    }

    public static LocalDateTime xmlGregorianCalendarToLocalDateTime(XMLGregorianCalendar xmlGregorianCalendar) {
        return KiwiXmlConverters.xmlGregorianCalendarToLocalDateTime(xmlGregorianCalendar, ZoneId.systemDefault());
    }

    public static LocalDateTime xmlGregorianCalendarToLocalDateTime(XMLGregorianCalendar xmlGregorianCalendar, ZoneId zoneId) {
        KiwiPreconditions.checkArgumentNotNull(xmlGregorianCalendar);
        KiwiPreconditions.checkArgumentNotNull(zoneId);
        return LocalDateTime.ofInstant(KiwiXmlConverters.xmlGregorianCalendarToInstant(xmlGregorianCalendar), zoneId);
    }

    public static long xmlGregorianCalendarToEpochMillis(XMLGregorianCalendar xmlGregorianCalendar) {
        return KiwiXmlConverters.xmlGregorianCalendarToInstant(xmlGregorianCalendar).toEpochMilli();
    }

    public static Date xmlGregorianCalendarToDate(XMLGregorianCalendar xmlGregorianCalendar) {
        long epochMillis = KiwiXmlConverters.xmlGregorianCalendarToEpochMillis(xmlGregorianCalendar);
        return new Date(epochMillis);
    }

    private KiwiXmlConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try {
            FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("Unable to create DatatypeFactory", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

