/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;

public class VaultConfiguration {
    @NotBlank
    private String ansibleVaultPath;
    @NotBlank
    private String vaultPasswordFilePath;
    @NotBlank
    private String tempDirectory;

    public VaultConfiguration() {
        this.tempDirectory = this.getJavaTempDir();
    }

    public VaultConfiguration(String ansibleVaultPath, String vaultPasswordFilePath, String tempDirectory) {
        this.ansibleVaultPath = KiwiPreconditions.requireNotBlank(ansibleVaultPath);
        this.vaultPasswordFilePath = KiwiPreconditions.requireNotBlank(vaultPasswordFilePath);
        this.tempDirectory = StringUtils.isBlank((CharSequence)tempDirectory) ? this.getJavaTempDir() : tempDirectory;
    }

    private String getJavaTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public VaultConfiguration copyOf() {
        return VaultConfiguration.builder().ansibleVaultPath(this.ansibleVaultPath).vaultPasswordFilePath(this.vaultPasswordFilePath).tempDirectory(this.tempDirectory).build();
    }

    @Generated
    public static VaultConfigurationBuilder builder() {
        return new VaultConfigurationBuilder();
    }

    @Generated
    public String getAnsibleVaultPath() {
        return this.ansibleVaultPath;
    }

    @Generated
    public String getVaultPasswordFilePath() {
        return this.vaultPasswordFilePath;
    }

    @Generated
    public String getTempDirectory() {
        return this.tempDirectory;
    }

    @Generated
    public void setAnsibleVaultPath(String ansibleVaultPath) {
        this.ansibleVaultPath = ansibleVaultPath;
    }

    @Generated
    public void setVaultPasswordFilePath(String vaultPasswordFilePath) {
        this.vaultPasswordFilePath = vaultPasswordFilePath;
    }

    @Generated
    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    @Generated
    public static class VaultConfigurationBuilder {
        @Generated
        private String ansibleVaultPath;
        @Generated
        private String vaultPasswordFilePath;
        @Generated
        private String tempDirectory;

        @Generated
        VaultConfigurationBuilder() {
        }

        @Generated
        public VaultConfigurationBuilder ansibleVaultPath(String ansibleVaultPath) {
            this.ansibleVaultPath = ansibleVaultPath;
            return this;
        }

        @Generated
        public VaultConfigurationBuilder vaultPasswordFilePath(String vaultPasswordFilePath) {
            this.vaultPasswordFilePath = vaultPasswordFilePath;
            return this;
        }

        @Generated
        public VaultConfigurationBuilder tempDirectory(String tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }

        @Generated
        public VaultConfiguration build() {
            return new VaultConfiguration(this.ansibleVaultPath, this.vaultPasswordFilePath, this.tempDirectory);
        }

        @Generated
        public String toString() {
            return "VaultConfiguration.VaultConfigurationBuilder(ansibleVaultPath=" + this.ansibleVaultPath + ", vaultPasswordFilePath=" + this.vaultPasswordFilePath + ", tempDirectory=" + this.tempDirectory + ")";
        }
    }
}

